/* 
    * $id:macros.h - Jalali Calendar
    * Useful Macros.
    * author: Ashkan Ghassemi (ghassemi at ftml dot net)
    * 
    * This program is free software; you can redistribute it and/or modify
    * it under the terms of the GNU General Public License as published by
    * the Free Software Foundation; either version 2 of the License, or
    * (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 

#ifndef __MACROS_H
#define __MACROS_H

#define BORDERS_LEN 4

#define MOVE_CURSOR(y, x) { \
    char x_arg[BORDERS_LEN] ; \
    char y_arg[BORDERS_LEN] ; \
    snprintf(x_arg, BORDERS_LEN, "%d", x) ; \
    snprintf(x_arg, BORDERS_LEN, "%d", y) ; \
    char* esc_str = (char*) malloc(4+strlen(x_arg)+strlen(y_arg)); \
    strncpy(esc_str, "\033[", 2) ; \
    strncat(esc_str, y_arg, BORDERS_LEN) ; \
    strncat(esc_str, ";", 1) ; \
    strncat(esc_str, x_arg, BORDERS_LEN) ; \
    strncat(esc_str, "H", 1) ; \
    fprintf(stdout, "%s", esc_str) ; \
}

#define FIX_CURSOR_COLUMN(x) { \
    char x_arg[BORDERS_LEN] = ""; \
    snprintf(x_arg, BORDERS_LEN, "%d", x) ; \
    char* esc_str = malloc(3+strlen(x_arg)) ; \
    strncpy(esc_str, "\033[", 2) ; \
    strncat(esc_str, x_arg, BORDERS_LEN) ; \
    strncat(esc_str, "C", 1) ; \
    fprintf(stdout, "%s", esc_str) ; \
}

#define FIX_CURSOR_ROW(dy) { \
    char y_arg[BORDERS_LEN] = ""; \
    snprintf(y_arg, BORDERS_LEN, "%d", dy) ; \
    char* esc_str = malloc(3+strlen(y_arg)) ; \
    strncpy(esc_str, "\033[", 2) ; \
    strncat(esc_str, y_arg, BORDERS_LEN) ; \
    strncat(esc_str, "A", 1) ; \
    fprintf(stdout, "%s", esc_str) ; \
}

#endif /* __MACROS_H */
