/* 
    * $id:main.c - Jalali Calendar
    * Tools for converting Jalali to Gregorian dates and vice-versa.
    * author: Ashkan Ghassemi (ghassemi at ftml dot net)
    * 
    * This program is free software; you can redistribute it and/or modify
    * it under the terms of the GNU General Public License as published by
    * the Free Software Foundation; either version 2 of the License, or
    * (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 

#include <string.h>
#include "jalali.h"

extern char* jalali_days[] ;
extern char* jalali_months[] ;

int 
main(int argc, char** argv) 
{
    long n_seconds = time(NULL) ;
    long n_days = (n_seconds / DAY_LEN) ;
    int factor = (argv[1]) ? atoi(argv[1]) : 0 ;
    n_days+= factor ;
    j_date jd ;
    convert_to_jalali(n_days, &jd) ;
    printf("ndays = %i\n", n_days) ;
    printf("Your desired day is %s %d of %s %d\n", jalali_days[jd.wday], jd.day, 
	   jalali_months[jd.month-1], jd.year) ;
    printf("day %d of year\n", jd.today) ;
}
