/*
 * jclassinfo
 * Copyright (C) 2003  Nicos Panayides
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Nicos Panayides
 * anarxia@gmx.net
 *
 * $Id: common.h,v 1.3 2003/11/27 12:08:27 anarxia Exp $
 */

#include "config.h"

/*
* Definitions for the do_flag bitfield.
* Values must be powers of 2
* and also not 0, -1, 63('?') (getopt sentinel values)
*/

/* Mask non-functionality options from the flag */
#define FUNCTION_OPTIONS(flag)	(flag & ~0xf)


/* Behaviour options */
#define XML_MODE			0x1
#define SECTION_TITLES		0x2
#define CLASSPATH			0x3	/* not added to do_flag */
#define RECURSIVE			0x4
#define SHOW_VERSION		0x5	/* not added to do_flag */
#define SHOW_HELP			0x6
#define VISIBILITY			0x7	/* not added to do_flag */
#define QUIET				0x8
#define BOOTCLASSPATH		0x9 /* not added to do_flag */

/* Functionality options */
#define GENERAL_INFO		0x10
#define CONSTANT_POOL		0x20
#define FIELDS				0x40
#define METHODS				0x80
#define ATTRIBUTES			0x100
#define PACKAGES			0x200
#define VERBOSE				0x400
#define CLASSES				0x800
#define METHOD_DEBUG_INFO	0x1000
#define METHOD_REF			0x2000
#define FIND_CLASS			0x4000
#define DISASM				0x8000
#define INVERSE				0x10000

void print_class(JavaClass *, int, JCVisibility);
void print_class_xml(JavaClass *, int, JCVisibility);
