/*
 * File    : ProjectLibraryEditorPanel.java
 * Created : 10-jun-2002 16:36
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.bags;

import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.Options;
import edu.xtec.util.SmallButton;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;


/**
 *
 * @author Francesc Busquets (fbusquets@xtec.net)
 * @version 1.0
 */
public class ActivityBagEditorPanel extends EditorPanel implements ListSelectionListener{

    boolean modified;
    public ActivityBagElementEditor currentItem;
    protected HashMap editPanels;
    protected EditorPanel currentPanel;
    
    /** Creates new form ProjectLibraryEditorPanel */
    public ActivityBagEditorPanel(Options options) {
        super(options);
        editPanels=new HashMap();
        ActivityBagEditor.createActions(options);
        ActivityBagElementEditor.createActions(options);
        initComponents();
        postInit(250, false, true);
        list.getSelectionModel().addListSelectionListener(this);                
        setEnabled(false);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        javax.swing.JScrollPane scroll;
        javax.swing.JSplitPane split;

        split = new javax.swing.JSplitPane();
        scroll = new javax.swing.JScrollPane();
        list = new javax.swing.JList();
        edit = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        list.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        scroll.setViewportView(list);

        split.setLeftComponent(scroll);

        edit.setLayout(new java.awt.BorderLayout());

        edit.setPreferredSize(new java.awt.Dimension(700, 600));
        split.setRightComponent(edit);

        add(split, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents


    public void setEnabled(boolean enabled){
        super.setEnabled(enabled);
        list.setEnabled(enabled);
        if(currentPanel!=null)
            currentPanel.setEnabled(enabled);        
    }
    
    public boolean checkIfEditorValid(Editor e) {
        return e instanceof ActivityBagEditor;
    }   
    
    protected ActivityBag getActivityBag(){
        if(editor==null)
            return null;
        else
            return ((ActivityBagEditor)editor).getActivityBag();
    }
    
    public void fillData(){
        ActivityBagEditor abe=getActivityBagEditor();
        list.setModel(abe==null ? new DefaultListModel() : abe.getListModel());
        if(abe!=null)
            abe.setListSelectionModel(list.getSelectionModel());
        else if(currentPanel!=null){
            currentPanel.removeEditor(true);
            edit.remove(currentPanel);
            currentPanel=null;
        }        
    }
    
    public void saveData(){
        ActivityBag ab=getActivityBag();
        if(ab!=null){
            //p.settings.title=checkEmptyString(titleText.getText(), true, "UNNAMED");
            //titleText.setText(p.settings.title);
        }
    }
        
    protected Icon getIcon(){
        return ActivityBagEditor.getIcon();
    }
    
    protected String getTitle(){
        return "Activity bag";
        //return options.getMsg("library_dlg_title");
    }
    
    ActivityBagEditor getActivityBagEditor(){
        return (ActivityBagEditor)getEditor();
    }
    
    protected void currentItemChanged(){
        if(edit!=null){
            if(currentPanel!=null){
                currentPanel.removeEditor(true);
            }
            if(currentItem!=null){
                Class pc=currentItem.getEditorPanelClass();
                EditorPanel ep=(EditorPanel)editPanels.get(pc);
                if(ep==null){
                    ep=currentItem.createEditorPanel(options);
                    editPanels.put(pc, ep);
                }
                ep.attachEditor(currentItem.getActivityEditor(), true);
                if(currentPanel!=ep){
                    if(currentPanel!=null)
                        edit.remove(currentPanel);
                    edit.add(ep, BorderLayout.CENTER);
                    edit.revalidate();
                    edit.repaint();
                }
                currentPanel=ep;
            }
        }
    }
    
    public boolean editActivity(String activityName){
        boolean result=false;
        if(activityName!=null && activityName.length()>0){
            ListModel model=list.getModel();
            int size=model.getSize();
            for(int i=0; i<model.getSize(); i++){
                Object o=model.getElementAt(i);
                if(o!=null && activityName.equals(o.toString())){
                    list.setSelectedIndex(i);
                    list.ensureIndexIsVisible(i);
                    result=true;
                    break;
                }
            }
        }
        return result;            
    }
    
    public void valueChanged(ListSelectionEvent ev) {
        
        if(ev!=null && ev.getValueIsAdjusting())
            return;
        
        ActivityBagEditor abe=getActivityBagEditor();
        if(abe!=null && currentItem!=null && currentItem.getActivityEditor()!=null){
            currentItem.getActivityEditor().collectData();
            currentItem.forgetActivityEditor();
        }
        currentItem=null;
        
        int row=list.getSelectedIndex();
        if(row>=0 && row<abe.getChildCount()){
            currentItem=(ActivityBagElementEditor)abe.getChildAt(row);
        }
        currentItemChanged();
    }
    
    public void focusGained(FocusEvent focusEvent) {
        if(currentPanel!=null)
            currentPanel.focusGained(focusEvent);
        else
            Editor.clearBasicActionsOwner();
    }
    
    public void focusLost(FocusEvent focusEvent) {
        if(currentPanel!=null)
            currentPanel.focusLost(focusEvent);
    }    
    
    
    protected void addActionsTo(Container cnt){
        cnt.add(new SmallButton(ActivityBagEditor.newActivityBagElementAction));
        cnt.add(new SmallButton(ActivityBagElementEditor.testActivityAction));
        cnt.add(new SmallButton(Editor.moveUpAction));
        cnt.add(new SmallButton(Editor.moveDownAction));
        cnt.add(new SmallButton(Editor.copyAction));
        cnt.add(new SmallButton(Editor.cutAction));
        cnt.add(new SmallButton(Editor.pasteAction));
        cnt.add(new SmallButton(Editor.deleteAction));
        cnt.add(new SmallButton(ActivityBagEditor.copyActivityAttributesAction));
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel edit;
    private javax.swing.JList list;
    // End of variables declaration//GEN-END:variables

}
