/*
 * Permission is hereby granted, free of charge, to any person obtaining a copy of 
 * this software and associated documentation files (the "Software"), to deal in 
 * the Software without restriction, including without limitation the rights to 
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies 
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
 * SOFTWARE.
 */
package org.jcodings.unicode;

import org.jcodings.Config;
import org.jcodings.unicode.UnicodeEncoding.CodeRangeEntry;

public class UnicodeProperties {
    static final CodeRangeEntry[]CodeRangeTable = Config.USE_UNICODE_PROPERTIES ?
            new CodeRangeEntry[] {
                new CodeRangeEntry("newline", "CR_NEWLINE"),
                new CodeRangeEntry("alpha", "CR_Alphabetic"),
                new CodeRangeEntry("blank", "CR_Blank"),
                new CodeRangeEntry("cntrl", "CR_Cc"),
                new CodeRangeEntry("digit", "CR_Nd"),
                new CodeRangeEntry("graph", "CR_Graph"),
                new CodeRangeEntry("lower", "CR_Lowercase"),
                new CodeRangeEntry("print", "CR_Print"),
                new CodeRangeEntry("punct", "CR_P"),
                new CodeRangeEntry("space", "CR_White_Space"),
                new CodeRangeEntry("upper", "CR_Uppercase"),
                new CodeRangeEntry("xdigit", "CR_ASCII_Hex_Digit"),
                new CodeRangeEntry("word", "CR_Word"),
                new CodeRangeEntry("alnum", "CR_Alnum"),
                new CodeRangeEntry("ascii", "CR_ASCII"),
                new CodeRangeEntry("any", "CR_Any"),
                new CodeRangeEntry("assigned", "CR_Assigned"),
                new CodeRangeEntry("c", "CR_C"),
                new CodeRangeEntry("other", "CR_C"),
                new CodeRangeEntry("cc", "CR_Cc"),
                new CodeRangeEntry("control", "CR_Cc"),
                new CodeRangeEntry("cf", "CR_Cf"),
                new CodeRangeEntry("format", "CR_Cf"),
                new CodeRangeEntry("cn", "CR_Cn"),
                new CodeRangeEntry("unassigned", "CR_Cn"),
                new CodeRangeEntry("co", "CR_Co"),
                new CodeRangeEntry("privateuse", "CR_Co"),
                new CodeRangeEntry("cs", "CR_Cs"),
                new CodeRangeEntry("surrogate", "CR_Cs"),
                new CodeRangeEntry("l", "CR_L"),
                new CodeRangeEntry("letter", "CR_L"),
                new CodeRangeEntry("ll", "CR_Ll"),
                new CodeRangeEntry("lowercaseletter", "CR_Ll"),
                new CodeRangeEntry("lm", "CR_Lm"),
                new CodeRangeEntry("modifierletter", "CR_Lm"),
                new CodeRangeEntry("lo", "CR_Lo"),
                new CodeRangeEntry("otherletter", "CR_Lo"),
                new CodeRangeEntry("lt", "CR_Lt"),
                new CodeRangeEntry("titlecaseletter", "CR_Lt"),
                new CodeRangeEntry("lu", "CR_Lu"),
                new CodeRangeEntry("uppercaseletter", "CR_Lu"),
                new CodeRangeEntry("m", "CR_M"),
                new CodeRangeEntry("mark", "CR_M"),
                new CodeRangeEntry("mc", "CR_Mc"),
                new CodeRangeEntry("spacingmark", "CR_Mc"),
                new CodeRangeEntry("me", "CR_Me"),
                new CodeRangeEntry("enclosingmark", "CR_Me"),
                new CodeRangeEntry("mn", "CR_Mn"),
                new CodeRangeEntry("nonspacingmark", "CR_Mn"),
                new CodeRangeEntry("n", "CR_N"),
                new CodeRangeEntry("number", "CR_N"),
                new CodeRangeEntry("nd", "CR_Nd"),
                new CodeRangeEntry("decimalnumber", "CR_Nd"),
                new CodeRangeEntry("nl", "CR_Nl"),
                new CodeRangeEntry("letternumber", "CR_Nl"),
                new CodeRangeEntry("no", "CR_No"),
                new CodeRangeEntry("othernumber", "CR_No"),
                new CodeRangeEntry("p", "CR_P"),
                new CodeRangeEntry("punctuation", "CR_P"),
                new CodeRangeEntry("pc", "CR_Pc"),
                new CodeRangeEntry("connectorpunctuation", "CR_Pc"),
                new CodeRangeEntry("pd", "CR_Pd"),
                new CodeRangeEntry("dashpunctuation", "CR_Pd"),
                new CodeRangeEntry("pe", "CR_Pe"),
                new CodeRangeEntry("closepunctuation", "CR_Pe"),
                new CodeRangeEntry("pf", "CR_Pf"),
                new CodeRangeEntry("finalpunctuation", "CR_Pf"),
                new CodeRangeEntry("pi", "CR_Pi"),
                new CodeRangeEntry("initialpunctuation", "CR_Pi"),
                new CodeRangeEntry("po", "CR_Po"),
                new CodeRangeEntry("otherpunctuation", "CR_Po"),
                new CodeRangeEntry("ps", "CR_Ps"),
                new CodeRangeEntry("openpunctuation", "CR_Ps"),
                new CodeRangeEntry("s", "CR_S"),
                new CodeRangeEntry("symbol", "CR_S"),
                new CodeRangeEntry("sc", "CR_Sc"),
                new CodeRangeEntry("currencysymbol", "CR_Sc"),
                new CodeRangeEntry("sk", "CR_Sk"),
                new CodeRangeEntry("modifiersymbol", "CR_Sk"),
                new CodeRangeEntry("sm", "CR_Sm"),
                new CodeRangeEntry("mathsymbol", "CR_Sm"),
                new CodeRangeEntry("so", "CR_So"),
                new CodeRangeEntry("othersymbol", "CR_So"),
                new CodeRangeEntry("z", "CR_Z"),
                new CodeRangeEntry("separator", "CR_Z"),
                new CodeRangeEntry("zl", "CR_Zl"),
                new CodeRangeEntry("lineseparator", "CR_Zl"),
                new CodeRangeEntry("zp", "CR_Zp"),
                new CodeRangeEntry("paragraphseparator", "CR_Zp"),
                new CodeRangeEntry("zs", "CR_Zs"),
                new CodeRangeEntry("spaceseparator", "CR_Zs"),
                new CodeRangeEntry("math", "CR_Math"),
                new CodeRangeEntry("alphabetic", "CR_Alphabetic"),
                new CodeRangeEntry("lowercase", "CR_Lowercase"),
                new CodeRangeEntry("uppercase", "CR_Uppercase"),
                new CodeRangeEntry("cased", "CR_Cased"),
                new CodeRangeEntry("caseignorable", "CR_Case_Ignorable"),
                new CodeRangeEntry("ci", "CR_Case_Ignorable"),
                new CodeRangeEntry("changeswhenlowercased", "CR_Changes_When_Lowercased"),
                new CodeRangeEntry("cwl", "CR_Changes_When_Lowercased"),
                new CodeRangeEntry("changeswhenuppercased", "CR_Changes_When_Uppercased"),
                new CodeRangeEntry("cwu", "CR_Changes_When_Uppercased"),
                new CodeRangeEntry("changeswhentitlecased", "CR_Changes_When_Titlecased"),
                new CodeRangeEntry("cwt", "CR_Changes_When_Titlecased"),
                new CodeRangeEntry("changeswhencasefolded", "CR_Changes_When_Casefolded"),
                new CodeRangeEntry("cwcf", "CR_Changes_When_Casefolded"),
                new CodeRangeEntry("changeswhencasemapped", "CR_Changes_When_Casemapped"),
                new CodeRangeEntry("cwcm", "CR_Changes_When_Casemapped"),
                new CodeRangeEntry("idstart", "CR_ID_Start"),
                new CodeRangeEntry("ids", "CR_ID_Start"),
                new CodeRangeEntry("idcontinue", "CR_ID_Continue"),
                new CodeRangeEntry("idc", "CR_ID_Continue"),
                new CodeRangeEntry("xidstart", "CR_XID_Start"),
                new CodeRangeEntry("xids", "CR_XID_Start"),
                new CodeRangeEntry("xidcontinue", "CR_XID_Continue"),
                new CodeRangeEntry("xidc", "CR_XID_Continue"),
                new CodeRangeEntry("defaultignorablecodepoint", "CR_Default_Ignorable_Code_Point"),
                new CodeRangeEntry("di", "CR_Default_Ignorable_Code_Point"),
                new CodeRangeEntry("graphemeextend", "CR_Grapheme_Extend"),
                new CodeRangeEntry("grext", "CR_Grapheme_Extend"),
                new CodeRangeEntry("graphemebase", "CR_Grapheme_Base"),
                new CodeRangeEntry("grbase", "CR_Grapheme_Base"),
                new CodeRangeEntry("graphemelink", "CR_Grapheme_Link"),
                new CodeRangeEntry("grlink", "CR_Grapheme_Link"),
                new CodeRangeEntry("common", "CR_Common"),
                new CodeRangeEntry("zyyy", "CR_Common"),
                new CodeRangeEntry("latin", "CR_Latin"),
                new CodeRangeEntry("latn", "CR_Latin"),
                new CodeRangeEntry("greek", "CR_Greek"),
                new CodeRangeEntry("grek", "CR_Greek"),
                new CodeRangeEntry("cyrillic", "CR_Cyrillic"),
                new CodeRangeEntry("cyrl", "CR_Cyrillic"),
                new CodeRangeEntry("armenian", "CR_Armenian"),
                new CodeRangeEntry("armn", "CR_Armenian"),
                new CodeRangeEntry("hebrew", "CR_Hebrew"),
                new CodeRangeEntry("hebr", "CR_Hebrew"),
                new CodeRangeEntry("arabic", "CR_Arabic"),
                new CodeRangeEntry("arab", "CR_Arabic"),
                new CodeRangeEntry("syriac", "CR_Syriac"),
                new CodeRangeEntry("syrc", "CR_Syriac"),
                new CodeRangeEntry("thaana", "CR_Thaana"),
                new CodeRangeEntry("thaa", "CR_Thaana"),
                new CodeRangeEntry("devanagari", "CR_Devanagari"),
                new CodeRangeEntry("deva", "CR_Devanagari"),
                new CodeRangeEntry("bengali", "CR_Bengali"),
                new CodeRangeEntry("beng", "CR_Bengali"),
                new CodeRangeEntry("gurmukhi", "CR_Gurmukhi"),
                new CodeRangeEntry("guru", "CR_Gurmukhi"),
                new CodeRangeEntry("gujarati", "CR_Gujarati"),
                new CodeRangeEntry("gujr", "CR_Gujarati"),
                new CodeRangeEntry("oriya", "CR_Oriya"),
                new CodeRangeEntry("orya", "CR_Oriya"),
                new CodeRangeEntry("tamil", "CR_Tamil"),
                new CodeRangeEntry("taml", "CR_Tamil"),
                new CodeRangeEntry("telugu", "CR_Telugu"),
                new CodeRangeEntry("telu", "CR_Telugu"),
                new CodeRangeEntry("kannada", "CR_Kannada"),
                new CodeRangeEntry("knda", "CR_Kannada"),
                new CodeRangeEntry("malayalam", "CR_Malayalam"),
                new CodeRangeEntry("mlym", "CR_Malayalam"),
                new CodeRangeEntry("sinhala", "CR_Sinhala"),
                new CodeRangeEntry("sinh", "CR_Sinhala"),
                new CodeRangeEntry("thai", "CR_Thai"),
                new CodeRangeEntry("lao", "CR_Lao"),
                new CodeRangeEntry("laoo", "CR_Lao"),
                new CodeRangeEntry("tibetan", "CR_Tibetan"),
                new CodeRangeEntry("tibt", "CR_Tibetan"),
                new CodeRangeEntry("myanmar", "CR_Myanmar"),
                new CodeRangeEntry("mymr", "CR_Myanmar"),
                new CodeRangeEntry("georgian", "CR_Georgian"),
                new CodeRangeEntry("geor", "CR_Georgian"),
                new CodeRangeEntry("hangul", "CR_Hangul"),
                new CodeRangeEntry("hang", "CR_Hangul"),
                new CodeRangeEntry("ethiopic", "CR_Ethiopic"),
                new CodeRangeEntry("ethi", "CR_Ethiopic"),
                new CodeRangeEntry("cherokee", "CR_Cherokee"),
                new CodeRangeEntry("cher", "CR_Cherokee"),
                new CodeRangeEntry("canadianaboriginal", "CR_Canadian_Aboriginal"),
                new CodeRangeEntry("cans", "CR_Canadian_Aboriginal"),
                new CodeRangeEntry("ogham", "CR_Ogham"),
                new CodeRangeEntry("ogam", "CR_Ogham"),
                new CodeRangeEntry("runic", "CR_Runic"),
                new CodeRangeEntry("runr", "CR_Runic"),
                new CodeRangeEntry("khmer", "CR_Khmer"),
                new CodeRangeEntry("khmr", "CR_Khmer"),
                new CodeRangeEntry("mongolian", "CR_Mongolian"),
                new CodeRangeEntry("mong", "CR_Mongolian"),
                new CodeRangeEntry("hiragana", "CR_Hiragana"),
                new CodeRangeEntry("hira", "CR_Hiragana"),
                new CodeRangeEntry("katakana", "CR_Katakana"),
                new CodeRangeEntry("kana", "CR_Katakana"),
                new CodeRangeEntry("bopomofo", "CR_Bopomofo"),
                new CodeRangeEntry("bopo", "CR_Bopomofo"),
                new CodeRangeEntry("han", "CR_Han"),
                new CodeRangeEntry("hani", "CR_Han"),
                new CodeRangeEntry("yi", "CR_Yi"),
                new CodeRangeEntry("yiii", "CR_Yi"),
                new CodeRangeEntry("olditalic", "CR_Old_Italic"),
                new CodeRangeEntry("ital", "CR_Old_Italic"),
                new CodeRangeEntry("gothic", "CR_Gothic"),
                new CodeRangeEntry("goth", "CR_Gothic"),
                new CodeRangeEntry("deseret", "CR_Deseret"),
                new CodeRangeEntry("dsrt", "CR_Deseret"),
                new CodeRangeEntry("inherited", "CR_Inherited"),
                new CodeRangeEntry("zinh", "CR_Inherited"),
                new CodeRangeEntry("qaai", "CR_Inherited"),
                new CodeRangeEntry("tagalog", "CR_Tagalog"),
                new CodeRangeEntry("tglg", "CR_Tagalog"),
                new CodeRangeEntry("hanunoo", "CR_Hanunoo"),
                new CodeRangeEntry("hano", "CR_Hanunoo"),
                new CodeRangeEntry("buhid", "CR_Buhid"),
                new CodeRangeEntry("buhd", "CR_Buhid"),
                new CodeRangeEntry("tagbanwa", "CR_Tagbanwa"),
                new CodeRangeEntry("tagb", "CR_Tagbanwa"),
                new CodeRangeEntry("limbu", "CR_Limbu"),
                new CodeRangeEntry("limb", "CR_Limbu"),
                new CodeRangeEntry("taile", "CR_Tai_Le"),
                new CodeRangeEntry("tale", "CR_Tai_Le"),
                new CodeRangeEntry("linearb", "CR_Linear_B"),
                new CodeRangeEntry("linb", "CR_Linear_B"),
                new CodeRangeEntry("ugaritic", "CR_Ugaritic"),
                new CodeRangeEntry("ugar", "CR_Ugaritic"),
                new CodeRangeEntry("shavian", "CR_Shavian"),
                new CodeRangeEntry("shaw", "CR_Shavian"),
                new CodeRangeEntry("osmanya", "CR_Osmanya"),
                new CodeRangeEntry("osma", "CR_Osmanya"),
                new CodeRangeEntry("cypriot", "CR_Cypriot"),
                new CodeRangeEntry("cprt", "CR_Cypriot"),
                new CodeRangeEntry("braille", "CR_Braille"),
                new CodeRangeEntry("brai", "CR_Braille"),
                new CodeRangeEntry("buginese", "CR_Buginese"),
                new CodeRangeEntry("bugi", "CR_Buginese"),
                new CodeRangeEntry("coptic", "CR_Coptic"),
                new CodeRangeEntry("copt", "CR_Coptic"),
                new CodeRangeEntry("qaac", "CR_Coptic"),
                new CodeRangeEntry("newtailue", "CR_New_Tai_Lue"),
                new CodeRangeEntry("talu", "CR_New_Tai_Lue"),
                new CodeRangeEntry("glagolitic", "CR_Glagolitic"),
                new CodeRangeEntry("glag", "CR_Glagolitic"),
                new CodeRangeEntry("tifinagh", "CR_Tifinagh"),
                new CodeRangeEntry("tfng", "CR_Tifinagh"),
                new CodeRangeEntry("sylotinagri", "CR_Syloti_Nagri"),
                new CodeRangeEntry("sylo", "CR_Syloti_Nagri"),
                new CodeRangeEntry("oldpersian", "CR_Old_Persian"),
                new CodeRangeEntry("xpeo", "CR_Old_Persian"),
                new CodeRangeEntry("kharoshthi", "CR_Kharoshthi"),
                new CodeRangeEntry("khar", "CR_Kharoshthi"),
                new CodeRangeEntry("balinese", "CR_Balinese"),
                new CodeRangeEntry("bali", "CR_Balinese"),
                new CodeRangeEntry("cuneiform", "CR_Cuneiform"),
                new CodeRangeEntry("xsux", "CR_Cuneiform"),
                new CodeRangeEntry("phoenician", "CR_Phoenician"),
                new CodeRangeEntry("phnx", "CR_Phoenician"),
                new CodeRangeEntry("phagspa", "CR_Phags_Pa"),
                new CodeRangeEntry("phag", "CR_Phags_Pa"),
                new CodeRangeEntry("nko", "CR_Nko"),
                new CodeRangeEntry("nkoo", "CR_Nko"),
                new CodeRangeEntry("sundanese", "CR_Sundanese"),
                new CodeRangeEntry("sund", "CR_Sundanese"),
                new CodeRangeEntry("lepcha", "CR_Lepcha"),
                new CodeRangeEntry("lepc", "CR_Lepcha"),
                new CodeRangeEntry("olchiki", "CR_Ol_Chiki"),
                new CodeRangeEntry("olck", "CR_Ol_Chiki"),
                new CodeRangeEntry("vai", "CR_Vai"),
                new CodeRangeEntry("vaii", "CR_Vai"),
                new CodeRangeEntry("saurashtra", "CR_Saurashtra"),
                new CodeRangeEntry("saur", "CR_Saurashtra"),
                new CodeRangeEntry("kayahli", "CR_Kayah_Li"),
                new CodeRangeEntry("kali", "CR_Kayah_Li"),
                new CodeRangeEntry("rejang", "CR_Rejang"),
                new CodeRangeEntry("rjng", "CR_Rejang"),
                new CodeRangeEntry("lycian", "CR_Lycian"),
                new CodeRangeEntry("lyci", "CR_Lycian"),
                new CodeRangeEntry("carian", "CR_Carian"),
                new CodeRangeEntry("cari", "CR_Carian"),
                new CodeRangeEntry("lydian", "CR_Lydian"),
                new CodeRangeEntry("lydi", "CR_Lydian"),
                new CodeRangeEntry("cham", "CR_Cham"),
                new CodeRangeEntry("taitham", "CR_Tai_Tham"),
                new CodeRangeEntry("lana", "CR_Tai_Tham"),
                new CodeRangeEntry("taiviet", "CR_Tai_Viet"),
                new CodeRangeEntry("tavt", "CR_Tai_Viet"),
                new CodeRangeEntry("avestan", "CR_Avestan"),
                new CodeRangeEntry("avst", "CR_Avestan"),
                new CodeRangeEntry("egyptianhieroglyphs", "CR_Egyptian_Hieroglyphs"),
                new CodeRangeEntry("egyp", "CR_Egyptian_Hieroglyphs"),
                new CodeRangeEntry("samaritan", "CR_Samaritan"),
                new CodeRangeEntry("samr", "CR_Samaritan"),
                new CodeRangeEntry("lisu", "CR_Lisu"),
                new CodeRangeEntry("bamum", "CR_Bamum"),
                new CodeRangeEntry("bamu", "CR_Bamum"),
                new CodeRangeEntry("javanese", "CR_Javanese"),
                new CodeRangeEntry("java", "CR_Javanese"),
                new CodeRangeEntry("meeteimayek", "CR_Meetei_Mayek"),
                new CodeRangeEntry("mtei", "CR_Meetei_Mayek"),
                new CodeRangeEntry("imperialaramaic", "CR_Imperial_Aramaic"),
                new CodeRangeEntry("armi", "CR_Imperial_Aramaic"),
                new CodeRangeEntry("oldsoutharabian", "CR_Old_South_Arabian"),
                new CodeRangeEntry("sarb", "CR_Old_South_Arabian"),
                new CodeRangeEntry("inscriptionalparthian", "CR_Inscriptional_Parthian"),
                new CodeRangeEntry("prti", "CR_Inscriptional_Parthian"),
                new CodeRangeEntry("inscriptionalpahlavi", "CR_Inscriptional_Pahlavi"),
                new CodeRangeEntry("phli", "CR_Inscriptional_Pahlavi"),
                new CodeRangeEntry("oldturkic", "CR_Old_Turkic"),
                new CodeRangeEntry("orkh", "CR_Old_Turkic"),
                new CodeRangeEntry("kaithi", "CR_Kaithi"),
                new CodeRangeEntry("kthi", "CR_Kaithi"),
                new CodeRangeEntry("batak", "CR_Batak"),
                new CodeRangeEntry("batk", "CR_Batak"),
                new CodeRangeEntry("brahmi", "CR_Brahmi"),
                new CodeRangeEntry("brah", "CR_Brahmi"),
                new CodeRangeEntry("mandaic", "CR_Mandaic"),
                new CodeRangeEntry("mand", "CR_Mandaic"),
                new CodeRangeEntry("whitespace", "CR_White_Space"),
                new CodeRangeEntry("wspace", "CR_White_Space"),
                new CodeRangeEntry("bidicontrol", "CR_Bidi_Control"),
                new CodeRangeEntry("bidic", "CR_Bidi_Control"),
                new CodeRangeEntry("joincontrol", "CR_Join_Control"),
                new CodeRangeEntry("joinc", "CR_Join_Control"),
                new CodeRangeEntry("dash", "CR_Dash"),
                new CodeRangeEntry("hyphen", "CR_Hyphen"),
                new CodeRangeEntry("quotationmark", "CR_Quotation_Mark"),
                new CodeRangeEntry("qmark", "CR_Quotation_Mark"),
                new CodeRangeEntry("terminalpunctuation", "CR_Terminal_Punctuation"),
                new CodeRangeEntry("term", "CR_Terminal_Punctuation"),
                new CodeRangeEntry("othermath", "CR_Other_Math"),
                new CodeRangeEntry("omath", "CR_Other_Math"),
                new CodeRangeEntry("hexdigit", "CR_Hex_Digit"),
                new CodeRangeEntry("hex", "CR_Hex_Digit"),
                new CodeRangeEntry("asciihexdigit", "CR_ASCII_Hex_Digit"),
                new CodeRangeEntry("ahex", "CR_ASCII_Hex_Digit"),
                new CodeRangeEntry("otheralphabetic", "CR_Other_Alphabetic"),
                new CodeRangeEntry("oalpha", "CR_Other_Alphabetic"),
                new CodeRangeEntry("ideographic", "CR_Ideographic"),
                new CodeRangeEntry("ideo", "CR_Ideographic"),
                new CodeRangeEntry("diacritic", "CR_Diacritic"),
                new CodeRangeEntry("dia", "CR_Diacritic"),
                new CodeRangeEntry("extender", "CR_Extender"),
                new CodeRangeEntry("ext", "CR_Extender"),
                new CodeRangeEntry("otherlowercase", "CR_Other_Lowercase"),
                new CodeRangeEntry("olower", "CR_Other_Lowercase"),
                new CodeRangeEntry("otheruppercase", "CR_Other_Uppercase"),
                new CodeRangeEntry("oupper", "CR_Other_Uppercase"),
                new CodeRangeEntry("noncharactercodepoint", "CR_Noncharacter_Code_Point"),
                new CodeRangeEntry("nchar", "CR_Noncharacter_Code_Point"),
                new CodeRangeEntry("othergraphemeextend", "CR_Other_Grapheme_Extend"),
                new CodeRangeEntry("ogrext", "CR_Other_Grapheme_Extend"),
                new CodeRangeEntry("idsbinaryoperator", "CR_IDS_Binary_Operator"),
                new CodeRangeEntry("idsb", "CR_IDS_Binary_Operator"),
                new CodeRangeEntry("idstrinaryoperator", "CR_IDS_Trinary_Operator"),
                new CodeRangeEntry("idst", "CR_IDS_Trinary_Operator"),
                new CodeRangeEntry("radical", "CR_Radical"),
                new CodeRangeEntry("unifiedideograph", "CR_Unified_Ideograph"),
                new CodeRangeEntry("uideo", "CR_Unified_Ideograph"),
                new CodeRangeEntry("otherdefaultignorablecodepoint", "CR_Other_Default_Ignorable_Code_Point"),
                new CodeRangeEntry("odi", "CR_Other_Default_Ignorable_Code_Point"),
                new CodeRangeEntry("deprecated", "CR_Deprecated"),
                new CodeRangeEntry("dep", "CR_Deprecated"),
                new CodeRangeEntry("softdotted", "CR_Soft_Dotted"),
                new CodeRangeEntry("sd", "CR_Soft_Dotted"),
                new CodeRangeEntry("logicalorderexception", "CR_Logical_Order_Exception"),
                new CodeRangeEntry("loe", "CR_Logical_Order_Exception"),
                new CodeRangeEntry("otheridstart", "CR_Other_ID_Start"),
                new CodeRangeEntry("oids", "CR_Other_ID_Start"),
                new CodeRangeEntry("otheridcontinue", "CR_Other_ID_Continue"),
                new CodeRangeEntry("oidc", "CR_Other_ID_Continue"),
                new CodeRangeEntry("sterm", "CR_STerm"),
                new CodeRangeEntry("variationselector", "CR_Variation_Selector"),
                new CodeRangeEntry("vs", "CR_Variation_Selector"),
                new CodeRangeEntry("patternwhitespace", "CR_Pattern_White_Space"),
                new CodeRangeEntry("patws", "CR_Pattern_White_Space"),
                new CodeRangeEntry("patternsyntax", "CR_Pattern_Syntax"),
                new CodeRangeEntry("patsyn", "CR_Pattern_Syntax"),
                new CodeRangeEntry("unknown", "CR_Unknown"),
                new CodeRangeEntry("zzzz", "CR_Unknown"),
                new CodeRangeEntry("age=1.1", "CR_Age_1_1"),
                new CodeRangeEntry("age=2.0", "CR_Age_2_0"),
                new CodeRangeEntry("age=2.1", "CR_Age_2_1"),
                new CodeRangeEntry("age=3.0", "CR_Age_3_0"),
                new CodeRangeEntry("age=3.1", "CR_Age_3_1"),
                new CodeRangeEntry("age=3.2", "CR_Age_3_2"),
                new CodeRangeEntry("age=4.0", "CR_Age_4_0"),
                new CodeRangeEntry("age=4.1", "CR_Age_4_1"),
                new CodeRangeEntry("age=5.0", "CR_Age_5_0"),
                new CodeRangeEntry("age=5.1", "CR_Age_5_1"),
                new CodeRangeEntry("age=5.2", "CR_Age_5_2"),
                new CodeRangeEntry("age=6.0", "CR_Age_6_0")
            } : new CodeRangeEntry[] {
                new CodeRangeEntry("newline", "CR_NEWLINE"),
                new CodeRangeEntry("alpha", "CR_Alphabetic"),
                new CodeRangeEntry("blank", "CR_Blank"),
                new CodeRangeEntry("cntrl", "CR_Cc"),
                new CodeRangeEntry("digit", "CR_Nd"),
                new CodeRangeEntry("graph", "CR_Graph"),
                new CodeRangeEntry("lower", "CR_Lowercase"),
                new CodeRangeEntry("print", "CR_Print"),
                new CodeRangeEntry("punct", "CR_P"),
                new CodeRangeEntry("space", "CR_White_Space"),
                new CodeRangeEntry("upper", "CR_Uppercase"),
                new CodeRangeEntry("xdigit", "CR_ASCII_Hex_Digit"),
                new CodeRangeEntry("word", "CR_Word"),
                new CodeRangeEntry("alnum", "CR_Alnum"),
                new CodeRangeEntry("ascii", "CR_ASCII")
            };
}
