import au.id.jericho.lib.html.*;
import java.util.*;
import java.io.*;
import java.net.*;

public class JSPTest {
	public static void main(String[] args) throws Exception {
		String sourceUrlString="data/jsp_test.html";
		if (args.length==0)
		  System.err.println("Using default argument of \""+sourceUrlString+'"');
		else
			sourceUrlString=args[0];
		if (sourceUrlString.indexOf(':')==-1) sourceUrlString="file:"+sourceUrlString;
		URL sourceUrl=new URL(sourceUrlString);
 		String htmlText=Util.getString(new InputStreamReader(sourceUrl.openStream()));

		Source source=new Source(htmlText);
		source.setLogWriter(new OutputStreamWriter(System.err)); // send log messages to stderr
		System.out.println("The following elements are found without first ignoring JSP tags:\n");
		System.out.println("(Notice the errors encountered by the parser in some of the HTML elements)\n");
		source.fullSequentialParse();
		display(source.findAllElements());

		System.out.println("*******************************************************************************\n\n\n");
		source=new Source(htmlText);
		source.setLogWriter(new OutputStreamWriter(System.err)); // send log messages to stderr
		List jspSegments=getJSPSegments(source);
		System.out.println("The following are the JSP segments in the page:\n");
		display(jspSegments);
		source.ignoreWhenParsing(jspSegments);
		source.fullSequentialParse();
		// Note the fullSequentialParse() call removes all tags from the cache, so those found in the getJSPSegments method will not be displayed below.
		System.out.println("\n\nThe following elements are found after ignoring the JSP segments:\n");
		display(source.findAllElements());
	}

	private static List getJSPSegments(Source source) {
		List jspSegments=new ArrayList();
		List commonServerTags=source.findAllTags(StartTagType.SERVER_COMMON);
		// Assume all common server tags are JSP segments, and add them to list:
		jspSegments.addAll(commonServerTags);
		// Find any taglib libraries being used:
		Set taglibNamespaces=new HashSet();
		taglibNamespaces.add("jsp");
		for (Iterator i=commonServerTags.iterator(); i.hasNext();) {
			StartTag commonServerTag=(StartTag)i.next();
			if (commonServerTag.charAt(2)!='@') continue;
			Attributes attributes=commonServerTag.parseAttributes();
			if (attributes==null || !source.toString().startsWith("taglib",attributes.getBegin())) continue;
			// we now know commonServerTag is a taglib declaration
			Attribute prefixAttribute=attributes.get("prefix");
			if (prefixAttribute==null) continue;
			String prefix=prefixAttribute.getValue();
			if (prefix!=null) taglibNamespaces.add(prefix);
		}
		for (Iterator i=taglibNamespaces.iterator(); i.hasNext();) {
			String taglibNamespace=(String)i.next();
			// find all elements in the taglib namespace:
			List taglibElements=source.findAllElements(taglibNamespace+':');
			// add the taglib elements to the list of JSP segments:
			jspSegments.addAll(taglibElements);
 		}
 		Collections.sort(jspSegments);
 		return jspSegments;
	}

	private static void display(Collection segments) {
		for (Iterator i=segments.iterator(); i.hasNext();) {
			Segment segment=(Segment)i.next();
			System.out.println("-------------------------------------------------------------------------------");
			System.out.println(segment.getDebugInfo());
			System.out.println(segment);
		}
	}
}
