set version=2.5
set package_name=jericho-html-%version%
set dependencies=compile-time-dependencies\slf4j-api-1.4.3.jar;compile-time-dependencies\commons-logging-api-1.1.jar;compile-time-dependencies\log4j-api-1.2.14.jar

md classes
md lib

rem ----- Compile source:
javac -g:none -classpath %dependencies% -d classes src\java\au\id\jericho\lib\html\*.java src\java\au\id\jericho\lib\html\nodoc\*.java
rem *** javac -g -classpath %dependencies% -d classes src\java\au\id\jericho\lib\html\*.java src\java\au\id\jericho\lib\html\nodoc\*.java
if errorlevel 1 goto end

rem ----- Create jar library:
jar -cf lib\%package_name%.jar -C classes .

@if "%1"=="-nojavadoc" goto buildsamples
rem ----- Create docs:
javadoc -quiet -windowtitle "Jericho HTML Parser %version%" -classpath src\java;classes;%dependencies% -use -d doc\api -subpackages au.id.jericho.lib.html -exclude au.id.jericho.lib.html.nodoc -noqualifier au.id.jericho.lib.html -group "Core Package" au.id.jericho.lib.html
type src\css\javadoc.css >> doc\api\stylesheet.css
copy src\doc\*.* doc\api

rem ----- Build the command line samples:
:buildsamples
md samples\console\classes
javac -g -deprecation -classpath lib/%package_name%.jar -d samples\console\classes samples\console\src\*.java
if errorlevel 1 goto end
md samples\console\bat_lib
echo @set package_name=%package_name%> samples\console\bat_lib\set_package_name.bat

@if "%1"=="-nojavadoc" goto end

rem ----- Create the sample web application WAR file:
md samples\webapps\JerichoHTML\WEB-INF\lib
copy /y lib\%package_name%.jar samples\webapps\JerichoHTML\WEB-INF\lib
jar -cf samples\webapps\JerichoHTML.war -C samples\webapps\JerichoHTML .

rem ----- Zip up the whole package:
jar -cMf ..\%package_name%.zip -C .. %package_name%

:end
