/*
 * Decompiled with CFR 0.152.
 */
package net.htmlparser.jericho;

import java.io.IOException;
import java.io.Writer;
import net.htmlparser.jericho.CharStreamSource;
import net.htmlparser.jericho.CharStreamSourceUtil;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.SourceFormatter;

public final class SourceCompactor
implements CharStreamSource {
    private final Segment segment;
    private String newLine = null;

    public SourceCompactor(Segment segment) {
        this.segment = segment;
    }

    public void writeTo(Writer writer) throws IOException {
        this.appendTo(writer);
        writer.flush();
    }

    public void appendTo(Appendable appendable) throws IOException {
        new SourceFormatter(this.segment).setTidyTags(true).setNewLine(this.newLine).setRemoveLineBreaks(true).appendTo(appendable);
    }

    public long getEstimatedMaximumOutputLength() {
        return this.segment.length();
    }

    public String toString() {
        return CharStreamSourceUtil.toString(this);
    }

    public SourceCompactor setNewLine(String string) {
        this.newLine = string;
        return this;
    }

    public String getNewLine() {
        if (this.newLine == null) {
            this.newLine = this.segment.source.getBestGuessNewLine();
        }
        return this.newLine;
    }
}

