/*
 * Copyright 2002 - 2007 JEuclid, http://jeuclid.sf.net
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: Messages.java 518 2007-09-14 08:29:58Z maxberger $ */

package net.sourceforge.jeuclid.app.mathviewer;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * Class to load i18n messages.
 * 
 * @version $Revision: 518 $
 */
public final class Messages {
    private static final String BUNDLE_NAME = "intl.mathviewer"; //$NON-NLS-1$

    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle
            .getBundle(Messages.BUNDLE_NAME);

    private Messages() {
    }

    /**
     * retrieve a translation string.
     * 
     * @param key
     *            key to look for
     * @return the expanded string
     */
    public static String getString(final String key) {
        try {
            return Messages.RESOURCE_BUNDLE.getString(key);
        } catch (final MissingResourceException e) {
            return '!' + key + '!';
        }
    }
}
