<?
    //AutoConfig Written by Robert Bogdon
    function searchPath($cmd) {	
	$dirs = explode(":", $_SERVER["PATH"]);

	if ($GLOBALS["os_type"]=="windows") {
	    $cmd.=".exe";
	    $dirs[]="c:/php";
	    $dirs[]="c:/rrdtool";
	    $dirs[]=$GLOBALS["jffnms_real_path"];
	}
	
	for($x=0; $x<=count($dirs); $x++)
    	    if(is_file($dirs[$x] . "/" . $cmd)) 
        	return $dirs[$x] . "/" . $cmd;
	
	return FALSE;
    }
   
    function autoConfig($option, $value) {
	switch($option) {
	    case "jffnms_real_path":
        	$value = str_replace("/htdocs/admin/setup.php", "", $_SERVER["SCRIPT_FILENAME"]);
        	break;
    	    case "tftp_real_path":
        	$value = $GLOBALS["jffnms_real_path"] . "/tftpd";
        	break;
    	    case "rrd_real_path":
        	$value = $GLOBALS["jffnms_real_path"] . "/rrd";
        	break;
    	    case "engine_temp_path":
        	$value = $GLOBALS["jffnms_real_path"] . "/engine/temp";
        	break;
    	    case "images_real_path":
        	$value = $GLOBALS["jffnms_real_path"] . "/htdocs/images/temp";
        	break;
    	    case "images_rel_path":
		$value = $_SERVER["REQUEST_URI"];
        	$value = str_replace("?", "", $value);
        	$value = str_replace("/admin/setup.php", "", $value);
        	$value .= "/images/temp";
        	break;
    	    case "log_path":
        	$value = $GLOBALS["jffnms_real_path"] . "/logs";
        	break;
    	    case "jffnms_rel_path":
		$value = $_SERVER["REQUEST_URI"];
        	$value = str_replace("?", "", $value);
        	$value = str_replace("/admin/setup.php", "", $value);
		if ($value=="") $value="/.";
        	break;
    	    case "jffnms_satellite_uri":
		$value = "http://".$_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"];
        	$value = str_replace("?", "", $value);
        	$value = str_replace("/admin/setup.php", "/admin/satellite.php", $value);
		break;
    	    case "php_executable":
        	$value = searchPath("php");
        	if($value == FALSE) $value = searchPath("php4");
        	break;
    	    case "neato_executable":
        	$value = searchPath("neato");
        	break;
    	    case "rrdtool_executable":
        	$value = searchPath("rrdtool");
        	break;
    	    case "diff_executable":
        	$value = searchPath("diff");
        	break;
    	    case "nmap_executable":
        	$value = searchPath("nmap");
		break;
    	    case "fping_executable":
        	$value = searchPath("fping");
        	break;
    	    case "smsclient_executable":
        	$value = searchPath("smsclient");
        	break;
	}
    
	//TEST Fix for Windows Path \\\\\ escaping problem
	if ($value) $value = str_replace("\\","/",$value);
    
	return $value;  
    }

    function check_phpconf($value) {
	list ($conf,$val_expect) = explode (",",$value);
	$val = ini_get($conf);

	if ($val==$val_expect) return TRUE;
	else return FALSE;
    }

    function check_enum($value) {
	return TRUE;
    }

    function check_module($value) {
	if(extension_loaded($value)) return TRUE;
	else return FALSE;
    }

    function check_db($value) {
	if (get_config_option("jffnms_access_method")=="local") {
	    if($conexion = @db_test()) return TRUE;
	    $GLOBALS["aux"] = @db_error();
	    return FALSE;
	} else
	    return TRUE;
    }

    function check_disable($value) {
	return TRUE;
    }

    function check_text($value) {
	return TRUE;
    }

    function check_menu($value) {
	return TRUE;
    }

    function check_color($value) {
	return TRUE;
    }
   
    function check_bool($value) {
	return TRUE;
    }

    function check_relative_directory($value) {
	if (is_array($_SERVER)) $host = $_SERVER["HTTP_HOST"];
	    else $host = $GLOBALS["HTTP_SERVER_VARS"]["HTTP_HOST"]; //OLD PHP
	    
	$test_url = "http://" . $host . $value . "/.check";
	if (@fopen($test_url,"r")) return TRUE;
	return FALSE;
    }

    function check_uri($test_url) {
	if (($test_url=="none") || (@fopen($test_url,"r"))) return TRUE;
	return FALSE;
    }

    function check_file($value) {
	if(is_file($value)) return TRUE;
	else return FALSE;
    }

    function check_directory($value) {
	if(($value!="../..") && is_dir($value)) return TRUE;
	else return FALSE;
    }

    function check_satellite() {
	if (is_object($GLOBALS["jffnms"]) && ($GLOBALS["jffnms"]->ping()=="pong")) return TRUE;
	else return FALSE;
    }
   
    function verifyConfig($type, $key, $value) {
	$type = "check_" . $type;

	if ($type($value)) $state = 1;
	else {
	    $aux = autoConfig($key, $value);
    	    if($type($aux)) {
        	$value = $aux;
        	$state = 1;
            } else {
        	$state = 2;
            }
        }
	return array($value, $state);
    }

    $no_db=1;
    include("../../conf/config.php");
    
    if ($action) {
        foreach ($jffnms_configuration as $key=>$data) {
	    $aux = "new_$key";
	    
	    if (($data["type"]=="bool") and ($$aux=="")) $$aux="0";
	    if (($data["type"]=="relative_directory") and ($$aux=="/")) $$aux="/.";
	    
	    if (($$aux!="") || ($data["type"]=="uri")) //if the value contaned something or was a URI (for satellite autoconfiguration)
		$jffnms_configuration[$key]["value"]=$$aux;
	
	    //disallow this characters
	    $jffnms_configuration[$key]["value"] = str_replace(array("'","|","=","\"","\\","&","#"),"",$jffnms_configuration[$key]["value"]);
	}

	save_ini($jffnms_config_ini_file,$config_profile,1);        
	include("../../conf/config.php");
    }

    if ($jffnms_initial_config_finished==1) { 
	if ((get_config_option("jffnms_access_method")=="local") && (db_test())) $no_db=0; 
	include("../auth.php"); 

	if (!profile("ADMIN_SYSTEM")) die ("<H1> You dont have Permission to access this page.</H1></HTML>");
    }

    //FIXME Convert to an autoconfig option
    if (strpos($_SERVER["SERVER_SOFTWARE"],"Win32") > 1) $os="windows";
    else $os="unix";
    $jffnms_configuration[os_type][value]=$os;
    $os_type = $os;
    
    adm_header("JFFNMS Setup",$normalColor);
    adm_table("50%","","center",0,0,1);

    table_row("<font size=4><b>JFFNMS Setup</b></font>","center",3);
    table_row("<font size=1>Using $jffnms_config_ini_file</font>","center",3);
    table_row(linktext("Help","http://www.jffnms.org/docs/jffnms_2.html#sec:setup"),"center",3);
    table_row("&nbsp;","center",3);
    
    adm_form($SCRIPT_NAME);

    foreach ($jffnms_configuration as $key=>$data) {
	unset($type);
	unset($value);
	unset($comment);
	unset($size);
	unset($state);
	unset($aux);
	unset($input);	
	
	extract($data);
	
	list($value, $state) = verifyConfig($type, $key, $value);                

	if (in_array($type,array("text","file","directory","relative_directory","uri","satellite")))
	    $input = "<input name='new_$key' type='text' size='$size' value='$value'>";

	if ($type=="disable") $input = "$value <input type='hidden' name='new_$key' value='$value'>";

	if ($type=="color") $input = select_color("new_$key",$value,1);

	if ($type=="file") if (is_file($value)) $state = 1; else $state=2;

	if ($type=="bool") $input = checkbox("new_$key",$value);

	if ($type=="menu") $comment="<br><font size=+1><u>$comment</u></font>";

	if ($type=="enum") $input = select_custom("new_$key",array_copy_value_to_key(explode("-",$size)),$value);
	
	if ($type=="db" || $type=="module" || $type=="phpconf") $state += 2;
	
	if ($type=="text" || $type=="menu" || $type=="disable" || $type=="enum" || $type=="color" || $type=="bool") unset($state);
	
	if ($state==1) $aux .= "<font color='green'><b>OK</b></font>";
	if ($state==2) $aux .= "<font color='red'><b>ERROR</b></font>";
	if ($state==3) $aux .= "<font color='green'><b>YES</b></font>";
	if ($state==4) $aux .= "<font color='red'><b>NO</b></font>";
	
	if ($type=="menu") std_table_row();
	else adm_table_row();

	adm_table_cell($comment,"right");
	adm_table_cell("&nbsp; &nbsp; $input","left");
	adm_table_cell("$aux&nbsp;","left");
	adm_table_row_close();
    }
    table_row("","",3);
    table_row(adm_form_submit("Save Changes"),"center",3);
    adm_form_close();
?>
