/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.event;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.sf.jftp.event.Event;
import net.sf.jftp.event.EventHandler;
import net.sf.jftp.event.FtpEvent;
import net.sf.jftp.net.FtpClient;

public class FtpEventHandler
implements EventHandler {
    private static ArrayList commands = null;
    private FtpClient client;
    private Hashtable methods = new Hashtable();

    public FtpEventHandler() {
        this.client = new FtpClient();
        Method[] m = this.getClass().getDeclaredMethods();
        String methodName = null;
        for (int i = 0; i < m.length; ++i) {
            methodName = m[i].getName();
            if (!commands.contains(methodName)) continue;
            this.methods.put(methodName, m[i]);
        }
    }

    public void open(Vector args) {
        System.out.println("***open");
        this.client.login((String)args.elementAt(1));
    }

    public void disconnect(Vector args) {
        System.out.println("***disconnect");
        this.client.disconnect();
    }

    public void cd(Vector args) {
        System.out.println("***cd");
        this.client.cd((String)args.elementAt(1));
    }

    public void pwd(Vector args) {
        System.out.println("***pwd");
        String directory = this.client.pwd();
    }

    public void get(Vector args) {
        System.out.println("***get");
        this.client.get((String)args.elementAt(1));
    }

    public void put(Vector args) {
        System.out.println("***put");
        this.client.put((String)args.elementAt(1));
    }

    public void quit(Vector args) {
        this.disconnect(args);
    }

    @Override
    public boolean handle(Event e) {
        String command;
        Method o;
        System.out.println(e.eventCode());
        System.out.println(((FtpEvent)e).eventMsg());
        StringTokenizer st = new StringTokenizer(((FtpEvent)e).eventMsg());
        Vector<String> list = new Vector<String>();
        while (st.hasMoreTokens()) {
            list.addElement(st.nextToken());
        }
        if (list.size() != 0 && (o = (Method)this.methods.get((command = (String)list.elementAt(0)).toLowerCase())) != null) {
            try {
                o.invoke((Object)this, list);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return true;
    }

    static {
        commands = new ArrayList();
        commands.add("account");
        commands.add("append");
        commands.add("ascii");
        commands.add("bell");
        commands.add("bye");
        commands.add("cd");
        commands.add("cdup");
        commands.add("chmod");
        commands.add("close");
        commands.add("cr");
        commands.add("delete");
        commands.add("dir");
        commands.add("disconnect");
        commands.add("form");
        commands.add("get");
        commands.add("glob");
        commands.add("hash");
        commands.add("idle");
        commands.add("image");
        commands.add("lcd");
        commands.add("mdelete");
        commands.add("mdir");
        commands.add("mget");
        commands.add("mkdir");
        commands.add("mls");
        commands.add("mode");
        commands.add("modtime");
        commands.add("mput");
        commands.add("newer");
        commands.add("nlist");
        commands.add("open");
        commands.add("passive");
        commands.add("put");
        commands.add("pwd");
        commands.add("quote");
        commands.add("recv");
        commands.add("reget");
        commands.add("rstatus");
        commands.add("rhelp");
        commands.add("rename");
        commands.add("reset");
        commands.add("restart");
        commands.add("rmdir");
        commands.add("runique");
        commands.add("send");
        commands.add("sendport");
        commands.add("site");
        commands.add("size");
        commands.add("status");
        commands.add("struct");
        commands.add("system");
        commands.add("sunique");
        commands.add("type");
        commands.add("user");
    }
}

