/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.tasks;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.system.logging.Log;

public class Displayer
extends JInternalFrame
implements ActionListener {
    public static boolean showCloseButton = false;
    private JTextArea info = new JTextArea(25, 50){

        @Override
        public Insets getInsets() {
            Insets std = super.getInsets();
            return new Insets(std.top + 5, std.left + 5, std.bottom + 5, std.right + 5);
        }
    };
    private JButton close = new JButton("Close");

    public Displayer(URL file, Font font) {
        super(file.getFile(), true, true, true, true);
        this.setLocation(50, 50);
        this.setSize(600, 540);
        this.getContentPane().setLayout(new BorderLayout());
        this.load(file);
        if (font != null) {
            this.info.setFont(font);
        } else {
            this.info.setFont(new Font("monospaced", 0, 11));
        }
        this.info.setEditable(false);
        JScrollPane jsp = new JScrollPane(this.info);
        this.getContentPane().add("Center", jsp);
        HPanel closeP = new HPanel();
        closeP.setLayout(new FlowLayout(1));
        closeP.add(this.close);
        this.close.addActionListener(this);
        if (showCloseButton) {
            this.getContentPane().add("South", closeP);
        }
        this.info.setCaretPosition(0);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close) {
            this.dispose();
        }
    }

    private void load(URL file) {
        String data = "";
        String now = "";
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(file.openStream()));
            while ((data = in.readLine()) != null) {
                now = now + data + "\n";
            }
        }
        catch (IOException e) {
            Log.debug(e + " @Displayer.load()");
        }
        this.info.setText(now);
    }

    @Override
    public Insets getInsets() {
        Insets std = super.getInsets();
        return new Insets(std.top + 5, std.left + 5, std.bottom + 5, std.right + 5);
    }
}

