/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.tasks;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jftp.gui.framework.HFrame;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.system.logging.Log;

public class ExternalDisplayer
extends HFrame
implements ActionListener {
    private JTextArea info = new JTextArea(25, 50);
    private JButton close = new JButton("Close");

    public ExternalDisplayer(URL file) {
        this.setTitle("Info...");
        this.setLocation(50, 50);
        this.setSize(600, 540);
        this.getContentPane().setLayout(new BorderLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ExternalDisplayer.this.dispose();
            }
        });
        this.load(file);
        this.info.setEditable(false);
        JScrollPane jsp = new JScrollPane(this.info);
        this.getContentPane().add("Center", jsp);
        HPanel closeP = new HPanel();
        closeP.setLayout(new FlowLayout(1));
        closeP.add(this.close);
        this.close.addActionListener(this);
        this.getContentPane().add("South", closeP);
        this.info.setCaretPosition(0);
        this.setVisible(true);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.close) {
            this.dispose();
        }
    }

    private void load(URL file) {
        String data = "";
        String now = "";
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(file.openStream()));
            while ((data = in.readLine()) != null) {
                now = now + data + "\n";
            }
        }
        catch (IOException e) {
            Log.debug(e + " @Displayer.load()");
        }
        this.info.setText(now);
    }

    @Override
    public Insets getInsets() {
        Insets std = super.getInsets();
        return new Insets(std.top + 5, std.left + 5, std.bottom + 5, std.right + 5);
    }
}

