/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.session;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.session.SessionOutputEcho;

public class SessionOutputReader {
    SessionChannelClient session;
    int pos = 0;
    int mark = 0;
    String output = "";

    public SessionOutputReader(SessionChannelClient sessionChannelClient) {
        this.session = sessionChannelClient;
        sessionChannelClient.addEventListener(new SessionOutputListener());
    }

    public String getOutput() {
        return this.output;
    }

    public int getPosition() {
        return this.pos;
    }

    public void markPosition(int n) {
        this.mark = n;
    }

    public void markCurrentPosition() {
        this.mark = this.pos;
    }

    public String getMarkedOutput() {
        return this.output.substring(this.mark, this.pos);
    }

    public synchronized boolean waitForString(String string, SessionOutputEcho sessionOutputEcho) throws InterruptedException {
        return this.waitForString(string, 0, sessionOutputEcho);
    }

    public synchronized boolean waitForString(String string) throws InterruptedException {
        return this.waitForString(string, 0, null);
    }

    public synchronized boolean waitForString(String string, int n) throws InterruptedException {
        return this.waitForString(string, n, null);
    }

    public synchronized boolean waitForString(String string, int n, SessionOutputEcho sessionOutputEcho) throws InterruptedException {
        long l = System.currentTimeMillis();
        while (this.output.indexOf(string, this.pos) == -1 && (System.currentTimeMillis() - l < (long)n || n == 0)) {
            int n2 = this.output.length();
            this.wait(n > 0 ? (long)n - (System.currentTimeMillis() - l) : 0L);
            if (this.output.length() <= n2 || sessionOutputEcho == null) continue;
            sessionOutputEcho.echo(this.output.substring(n2, this.output.length()));
        }
        if (this.output.indexOf(string, this.pos) > -1) {
            this.pos = this.output.indexOf(string, this.pos) + string.length();
            return true;
        }
        return false;
    }

    public synchronized void echoLineByLineToClose(SessionOutputEcho sessionOutputEcho) throws InterruptedException {
        while (this.session.isOpen()) {
            this.waitForString("\n", 1000, sessionOutputEcho);
        }
    }

    private synchronized void breakWaiting() {
        this.notifyAll();
    }

    class SessionOutputListener
    implements ChannelEventListener {
        SessionOutputListener() {
        }

        public void onChannelOpen(Channel channel) {
        }

        public void onChannelClose(Channel channel) {
            SessionOutputReader.this.breakWaiting();
        }

        public void onChannelEOF(Channel channel) {
            SessionOutputReader.this.breakWaiting();
        }

        public void onDataSent(Channel channel, byte[] byArray) {
        }

        public void onDataReceived(Channel channel, byte[] byArray) {
            SessionOutputReader.this.output = SessionOutputReader.this.output + new String(byArray);
            SessionOutputReader.this.breakWaiting();
        }
    }
}

