/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPublicKeyFormatFactory {
    private static String defaultFormat;
    private static HashMap formatTypes;
    private static Log log;
    private static Vector types;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SshPublicKeyFormatFactory;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$SECSHPublicKeyFormat;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$OpenSSHPublicKeyFormat;
    static /* synthetic */ Class class$com$sshtools$j2ssh$configuration$SshAPIConfiguration;

    public static List getSupportedFormats() {
        return types;
    }

    public static SshPublicKeyFormat newInstance(String string) throws InvalidSshKeyException {
        try {
            if (formatTypes.containsKey(string)) {
                return (SshPublicKeyFormat)((Class)formatTypes.get(string)).newInstance();
            }
            throw new InvalidSshKeyException("The format type " + string + " is not supported");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidSshKeyException("Illegal access to class implementation of " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidSshKeyException("Failed to create instance of format type " + string);
        }
    }

    public static String getDefaultFormatType() {
        return defaultFormat;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        formatTypes = new HashMap();
        log = LogFactory.getLog(class$com$sshtools$j2ssh$transport$publickey$SshPublicKeyFormatFactory == null ? (class$com$sshtools$j2ssh$transport$publickey$SshPublicKeyFormatFactory = SshPublicKeyFormatFactory.class$("com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormatFactory")) : class$com$sshtools$j2ssh$transport$publickey$SshPublicKeyFormatFactory);
        types = new Vector();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add((class$com$sshtools$j2ssh$transport$publickey$SECSHPublicKeyFormat == null ? (class$com$sshtools$j2ssh$transport$publickey$SECSHPublicKeyFormat = SshPublicKeyFormatFactory.class$("com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat")) : class$com$sshtools$j2ssh$transport$publickey$SECSHPublicKeyFormat).getName());
        arrayList.add((class$com$sshtools$j2ssh$transport$publickey$OpenSSHPublicKeyFormat == null ? (class$com$sshtools$j2ssh$transport$publickey$OpenSSHPublicKeyFormat = SshPublicKeyFormatFactory.class$("com.sshtools.j2ssh.transport.publickey.OpenSSHPublicKeyFormat")) : class$com$sshtools$j2ssh$transport$publickey$OpenSSHPublicKeyFormat).getName());
        defaultFormat = "SECSH-PublicKey-Base64Encoded";
        try {
            if (ConfigurationLoader.isConfigurationAvailable(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshPublicKeyFormatFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration)) {
                object = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(class$com$sshtools$j2ssh$configuration$SshAPIConfiguration == null ? (class$com$sshtools$j2ssh$configuration$SshAPIConfiguration = SshPublicKeyFormatFactory.class$("com.sshtools.j2ssh.configuration.SshAPIConfiguration")) : class$com$sshtools$j2ssh$configuration$SshAPIConfiguration);
                defaultFormat = object.getDefaultPublicKeyFormat();
                arrayList.addAll(object.getPublicKeyFormats());
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        log.debug("Default public key format will be " + defaultFormat);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Class clazz = ConfigurationLoader.getExtensionClass(string);
                object = (SshPublicKeyFormat)clazz.newInstance();
                log.debug("Installing " + object.getFormatType() + " public key format");
                formatTypes.put(object.getFormatType(), clazz);
                types.add(object.getFormatType());
            }
            catch (Exception exception) {
                log.warn("Public key format implemented by " + string + " will not be available", exception);
            }
        }
    }
}

