/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfilechooser;

import com.sun.xfilechooser.BeanXFile;
import com.sun.xfilechooser.GenericXFileSystemView;
import com.sun.xfilechooser.UnixXFileSystemView;
import com.sun.xfilechooser.WindowsXFileSystemView;
import java.io.File;
import java.util.Vector;
import javax.swing.filechooser.FileSystemView;

public abstract class XFileSystemView
extends FileSystemView {
    static FileSystemView windowsXFileSystemView = null;
    static FileSystemView unixXFileSystemView = null;
    static FileSystemView genericXFileSystemView = null;

    public File createFileObject(File dir, String filename) {
        if (dir == null) {
            return new BeanXFile(filename);
        }
        return new BeanXFile(dir, filename);
    }

    public File createFileObject(String path) {
        return new BeanXFile(path);
    }

    public static FileSystemView getFileSystemView() {
        if (File.separatorChar == '\\') {
            if (windowsXFileSystemView == null) {
                windowsXFileSystemView = new WindowsXFileSystemView();
            }
            return windowsXFileSystemView;
        }
        if (File.separatorChar == '/') {
            if (unixXFileSystemView == null) {
                unixXFileSystemView = new UnixXFileSystemView();
            }
            return unixXFileSystemView;
        }
        if (genericXFileSystemView == null) {
            genericXFileSystemView = new GenericXFileSystemView();
        }
        return genericXFileSystemView;
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        Vector<BeanXFile> files = new Vector<BeanXFile>();
        String[] names = dir.list();
        int nameCount = names == null ? 0 : names.length;
        int i = 0;
        while (i < nameCount) {
            BeanXFile f = (BeanXFile)this.createFileObject(dir, names[i]);
            if (f.exists()) {
                if (useFileHiding) {
                    if (!this.isHiddenFile(f)) {
                        files.addElement(f);
                    }
                } else {
                    files.addElement(f);
                }
            }
            ++i;
        }
        Object[] fileArray = new BeanXFile[files.size()];
        files.copyInto(fileArray);
        return fileArray;
    }

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File getParentDirectory(File dir) {
        BeanXFile f;
        String parentFilename;
        String dirname = null;
        if (dir != null && (parentFilename = (f = (BeanXFile)this.createFileObject(dirname = dir.getAbsolutePath())).getParent()) != null) {
            return new BeanXFile(parentFilename);
        }
        return null;
    }

    public boolean isRoot(File f) {
        String parentPath = f.getParent();
        if (parentPath == null) {
            return true;
        }
        BeanXFile parent = new BeanXFile(parentPath);
        return parent.equals(f);
    }
}

