/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.UnsupportedEncodingException;
import jcifs.Config;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SmbSession;
import jcifs.util.Hexdump;

class SmbComTreeConnectAndX
extends AndXServerMessageBlock {
    private static final boolean DISABLE_PLAIN_TEXT_PASSWORDS = Config.getBoolean("jcifs.smb.client.disablePlainTextPasswords", true);
    private SmbSession session;
    private boolean disconnectTid = false;
    private String path;
    private String service;
    private byte[] password;
    private int passwordLength;
    private static byte[] batchLimits = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 0};

    SmbComTreeConnectAndX(SmbSession session, String path, String service, ServerMessageBlock andx) {
        super(andx);
        this.session = session;
        this.path = path;
        this.service = service;
        this.command = (byte)117;
    }

    @Override
    int getBatchLimit(byte command) {
        int c = command & 0xFF;
        switch (c) {
            case 16: {
                return batchLimits[0];
            }
            case 0: {
                return batchLimits[2];
            }
            case 6: {
                return batchLimits[3];
            }
            case 1: {
                return batchLimits[4];
            }
            case 45: {
                return batchLimits[5];
            }
            case 7: {
                return batchLimits[6];
            }
            case 37: {
                return batchLimits[7];
            }
            case 8: {
                return batchLimits[8];
            }
        }
        return 0;
    }

    @Override
    int writeParameterWordsWireFormat(byte[] dst, int dstIndex) {
        if (this.session.transport.server.security == 0 && (this.session.auth.hashesExternal || this.session.auth.password.length() > 0)) {
            if (this.session.transport.server.encryptedPasswords) {
                this.password = this.session.auth.getAnsiHash(this.session.transport.server.encryptionKey);
                this.passwordLength = this.password.length;
            } else {
                if (DISABLE_PLAIN_TEXT_PASSWORDS) {
                    throw new RuntimeException("Plain text passwords are disabled");
                }
                this.password = new byte[(this.session.auth.password.length() + 1) * 2];
                this.passwordLength = this.writeString(this.session.auth.password, this.password, 0);
            }
        } else {
            this.passwordLength = 1;
        }
        dst[dstIndex++] = this.disconnectTid ? (byte)1 : 0;
        dst[dstIndex++] = 0;
        SmbComTreeConnectAndX.writeInt2(this.passwordLength, dst, dstIndex);
        return 4;
    }

    @Override
    int writeBytesWireFormat(byte[] dst, int dstIndex) {
        int start = dstIndex;
        if (this.session.transport.server.security == 0 && (this.session.auth.hashesExternal || this.session.auth.password.length() > 0)) {
            System.arraycopy(this.password, 0, dst, dstIndex, this.passwordLength);
            dstIndex += this.passwordLength;
        } else {
            dst[dstIndex++] = 0;
        }
        dstIndex += this.writeString(this.path, dst, dstIndex);
        try {
            System.arraycopy(this.service.getBytes("ASCII"), 0, dst, dstIndex, this.service.length());
        }
        catch (UnsupportedEncodingException uee) {
            return 0;
        }
        dstIndex += this.service.length();
        dst[dstIndex++] = 0;
        return dstIndex - start;
    }

    @Override
    int readParameterWordsWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    int readBytesWireFormat(byte[] buffer, int bufferIndex) {
        return 0;
    }

    @Override
    public String toString() {
        String result = new String("SmbComTreeConnectAndX[" + super.toString() + ",disconnectTid=" + this.disconnectTid + ",passwordLength=" + this.passwordLength + ",password=" + Hexdump.toHexString(this.password, this.passwordLength, 0) + ",path=" + this.path + ",service=" + this.service + "]");
        return result;
    }

    static {
        String s = Config.getProperty("jcifs.smb.client.TreeConnectAndX.CheckDirectory");
        if (s != null) {
            SmbComTreeConnectAndX.batchLimits[0] = Byte.parseByte(s);
        }
        if ((s = Config.getProperty("jcifs.smb.client.TreeConnectAndX.CreateDirectory")) != null) {
            SmbComTreeConnectAndX.batchLimits[2] = Byte.parseByte(s);
        }
        if ((s = Config.getProperty("jcifs.smb.client.TreeConnectAndX.Delete")) != null) {
            SmbComTreeConnectAndX.batchLimits[3] = Byte.parseByte(s);
        }
        if ((s = Config.getProperty("jcifs.smb.client.TreeConnectAndX.DeleteDirectory")) != null) {
            SmbComTreeConnectAndX.batchLimits[4] = Byte.parseByte(s);
        }
        if ((s = Config.getProperty("jcifs.smb.client.TreeConnectAndX.OpenAndX")) != null) {
            SmbComTreeConnectAndX.batchLimits[5] = Byte.parseByte(s);
        }
        if ((s = Config.getProperty("jcifs.smb.client.TreeConnectAndX.Rename")) != null) {
            SmbComTreeConnectAndX.batchLimits[6] = Byte.parseByte(s);
        }
        if ((s = Config.getProperty("jcifs.smb.client.TreeConnectAndX.Transaction")) != null) {
            SmbComTreeConnectAndX.batchLimits[7] = Byte.parseByte(s);
        }
        if ((s = Config.getProperty("jcifs.smb.client.TreeConnectAndX.QueryInformation")) != null) {
            SmbComTreeConnectAndX.batchLimits[8] = Byte.parseByte(s);
        }
    }
}

