/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.AppMenuBar;
import net.sf.jftp.gui.base.DownloadList;
import net.sf.jftp.gui.base.DownloadQueue;
import net.sf.jftp.gui.base.LocalDir;
import net.sf.jftp.gui.base.LogFlusher;
import net.sf.jftp.gui.base.RemoteDir;
import net.sf.jftp.gui.base.StatusPanel;
import net.sf.jftp.gui.base.dir.Dir;
import net.sf.jftp.gui.base.dir.DirEntry;
import net.sf.jftp.gui.framework.FileTransferable;
import net.sf.jftp.gui.framework.GUIDefaults;
import net.sf.jftp.gui.framework.HDesktopBackground;
import net.sf.jftp.gui.framework.HImage;
import net.sf.jftp.gui.hostchooser.HostChooser;
import net.sf.jftp.gui.hostchooser.SftpHostChooser;
import net.sf.jftp.gui.tasks.HostInfo;
import net.sf.jftp.net.BasicConnection;
import net.sf.jftp.net.ConnectionHandler;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.FilesystemConnection;
import net.sf.jftp.net.FtpConnection;
import net.sf.jftp.system.LocalIO;
import net.sf.jftp.system.UpdateDaemon;
import net.sf.jftp.system.logging.Log;
import net.sf.jftp.system.logging.Logger;
import net.sf.jftp.tools.RSSFeeder;

public class JFtp
extends JPanel
implements WindowListener,
ComponentListener,
Logger,
ChangeListener,
InternalFrameListener {
    public static boolean mainUsed = false;
    public static StatusPanel statusP;
    public static JLabel statusL;
    public static JFrame mainFrame;
    public static Dir localDir;
    public static Dir remoteDir;
    public static DownloadList dList;
    public static DownloadQueue dQueue;
    public static boolean uiBlocked;
    public static HostInfo hostinfo;
    private static ConnectionHandler defaultConnectionHandler;
    public static JDesktopPane desktop;
    private static JScrollPane logSp;
    public static JTextArea log;
    public static AppMenuBar menuBar;
    public static final int CAPACITY = 9;
    public static final int CONNECTION_DATA_LENGTH = 10;
    public static DropTarget dropTarget;
    public static DropTargetListener dtListener;
    public static int acceptableActions;
    private LogFlusher flusher;
    private boolean initSize = true;
    public JTabbedPane remoteConnectionPanel = new JTabbedPane();
    public JTabbedPane localConnectionPanel = new JTabbedPane();
    private String oldText = "";
    private HDesktopBackground background;
    private JSplitPane workP = null;
    private JSplitPane logP = null;
    private JInternalFrame j1;
    private JInternalFrame j2;
    private JInternalFrame j3;
    private JInternalFrame j4;
    private JInternalFrame j5;
    private Hashtable internalFrames = new Hashtable();
    public HostChooser hc;
    private String buffer = "";
    private long oldtime = 0L;
    private UpdateDaemon daemon;
    public RSSFeeder feeder;

    public JFtp() {
        Log.setLogger(this);
        if (statusP != null) {
            statusP.remove(JFtp.statusP.close);
        }
        this.init();
    }

    public JFtp(boolean mainUsed) {
        Log.setLogger(this);
        JFtp.mainUsed = mainUsed;
        this.init();
    }

    public void init() {
        dtListener = new DTListener();
        dropTarget = new DropTarget(this, acceptableActions, dtListener, true);
        this.setLayout(new BorderLayout());
        this.setBackground(GUIDefaults.mainBack);
        this.setForeground(GUIDefaults.front);
        statusP = new StatusPanel(this);
        this.add("North", statusP);
        localDir = new LocalDir(Settings.defaultWorkDir);
        localDir.setDownloadList(dList);
        remoteDir = new RemoteDir();
        remoteDir.setDownloadList(dList);
        desktop.setDropTarget(dropTarget);
        Dimension d = Settings.getWindowSize();
        this.setPreferredSize(d);
        this.setSize(d);
        int width = (int)d.getWidth();
        int height = (int)d.getHeight();
        dList.setMinimumSize(new Dimension((int)((double)width / 2.5), (int)((double)height * 0.2)));
        dList.setPreferredSize(new Dimension((int)((double)width / 2.5), (int)((double)height * 0.25)));
        dList.setSize(new Dimension((int)((double)width / 2.5), (int)((double)height * 0.25)));
        desktop.setDragMode(1);
        this.addBackgroundImage();
        this.j1 = new JInternalFrame("Local filesystem", true, false, true, true);
        this.j1.setMinimumSize(new Dimension(300, 300));
        this.j1.setLocation(5, 5);
        this.localConnectionPanel.addTab("file://", null, (Component)((Object)localDir), "Filesystem");
        this.localConnectionPanel.setSelectedIndex(0);
        this.localConnectionPanel.addChangeListener(this);
        this.j1.getContentPane().add(this.localConnectionPanel);
        localDir.fresh();
        desktop.add(this.j1);
        this.j1.setDefaultCloseOperation(0);
        this.j1.addInternalFrameListener(this);
        this.j1.pack();
        this.j1.setSize(new Dimension(400, this.j1.getSize().height));
        this.j1.show();
        this.j2 = new JInternalFrame("Remote connections", true, false, true, true);
        this.j2.setLocation(430, 5);
        this.remoteConnectionPanel.addTab("file://", null, (Component)((Object)remoteDir), "Filesystem");
        this.remoteConnectionPanel.setSelectedIndex(0);
        this.remoteConnectionPanel.addChangeListener(this);
        this.j2.getContentPane().add(this.remoteConnectionPanel);
        desktop.add(this.j2);
        this.j2.setDefaultCloseOperation(0);
        this.j2.addInternalFrameListener(this);
        this.j2.pack();
        this.j2.setSize(new Dimension(415, this.j1.getSize().height));
        this.j2.show();
        log = new JTextArea();
        log.setBackground(GUIDefaults.light);
        log.setForeground(GUIDefaults.front);
        log.setEditable(false);
        logSp = new JScrollPane(log);
        logSp.setSize(new Dimension(438, 148));
        this.j5 = new JInternalFrame("Queue System", true, false, true, true);
        this.j5.setLocation(5, 400);
        this.j5.getContentPane().add((Component)dQueue, "Center");
        desktop.add(this.j5);
        this.j5.pack();
        this.j5.setSize(new Dimension(440, 150));
        this.j5.show();
        this.j3 = new JInternalFrame("Log", true, false, true, true);
        int x = JFtp.desktop.getSize().width / 2;
        this.j3.setLocation(5, 425);
        this.j3.getContentPane().add((Component)logSp, "Center");
        desktop.add(this.j3);
        this.j3.pack();
        this.j3.setSize(new Dimension(440, 150));
        this.j3.show();
        this.j4 = new JInternalFrame("Download Manager", true, false, true, true);
        this.j4.setLocation(450, 425);
        this.j4.getContentPane().add((Component)dList, "Center");
        desktop.add(this.j4);
        this.j4.pack();
        this.j4.setSize(new Dimension(380, 150));
        this.j4.show();
        this.j1.toFront();
        this.j2.toFront();
        this.add("Center", desktop);
        JToolBar j = new JToolBar();
        j.setFloatable(false);
        j.add((Component)StatusPanel.status, 0);
        if (Settings.getEnableRSS()) {
            this.feeder = new RSSFeeder();
            j.add(this.feeder);
        }
        this.add("South", j);
        this.addComponentListener(this);
        this.componentResized(new ComponentEvent(log, 0));
        this.restoreInternalPositions();
        this.validate();
        this.setVisible(true);
        if (!mainUsed) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JFtp.this.chooseHost();
                }
            });
        } else {
            this.chooseHost();
        }
        this.flusher = new LogFlusher();
        this.daemon = new UpdateDaemon(this);
    }

    protected void chooseHost() {
        this.hc = new HostChooser(this);
        if (!mainUsed) {
            this.hc.update();
        }
    }

    public static String getHost() {
        return statusP.getHost();
    }

    public static void setHost(String which) {
        statusP.setHost(which);
    }

    public static void localUpdate() {
        localDir.fresh();
    }

    public static void remoteUpdate() {
        remoteDir.fresh();
    }

    private void saveInternalPositions() {
        this.saveInternalPosition(this.j1, "local");
        this.saveInternalPosition(this.j2, "remote");
        this.saveInternalPosition(this.j5, "queue");
        this.saveInternalPosition(this.j3, "log");
        this.saveInternalPosition(this.j4, "manager");
    }

    private void restoreInternalPositions() {
        if (!Settings.getProperty("jftp.iframes.resize").equals("false")) {
            this.restoreInternalPosition(this.j1, "local");
            this.restoreInternalPosition(this.j2, "remote");
            this.restoreInternalPosition(this.j5, "queue");
            this.restoreInternalPosition(this.j3, "log");
            this.restoreInternalPosition(this.j4, "manager");
        }
    }

    private void restoreInternalPosition(JInternalFrame f, String desc) {
        String x = Settings.getProperty("jftp.iframes." + desc + ".x");
        String y = Settings.getProperty("jftp.iframes." + desc + ".y");
        String w = Settings.getProperty("jftp.iframes." + desc + ".width");
        String h = Settings.getProperty("jftp.iframes." + desc + ".height");
        if (x.indexOf(".") >= 0) {
            x = x.substring(0, x.indexOf("."));
        }
        if (y.indexOf(".") >= 0) {
            y = y.substring(0, y.indexOf("."));
        }
        try {
            f.setLocation(Integer.parseInt(x), Integer.parseInt(y));
            f.setSize(Integer.parseInt(w), Integer.parseInt(h));
        }
        catch (Exception ex) {
            Log.out("Can not set internal fram position for: " + desc);
            ex.printStackTrace();
        }
    }

    private void saveInternalPosition(JInternalFrame f, String desc) {
        Point p = f.getLocation();
        Settings.setProperty("jftp.iframes." + desc + ".x", "" + p.getX());
        Settings.setProperty("jftp.iframes." + desc + ".y", "" + p.getY());
        Settings.setProperty("jftp.iframes." + desc + ".width", f.getWidth());
        Settings.setProperty("jftp.iframes." + desc + ".height", f.getHeight());
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.saveInternalPositions();
        Settings.setProperty("jftp.window.width", this.getWidth());
        Settings.setProperty("jftp.window.height", this.getHeight());
        if (!mainUsed) {
            Settings.setProperty("jftp.window.x", (int)this.getLocationOnScreen().getX());
            Settings.setProperty("jftp.window.y", (int)this.getLocationOnScreen().getY());
        } else {
            Settings.setProperty("jftp.window.x", (int)mainFrame.getLocationOnScreen().getX());
            Settings.setProperty("jftp.window.y", (int)mainFrame.getLocationOnScreen().getY());
        }
        Settings.save();
        JFtp.safeDisconnect();
        if (Settings.isStandalone) {
            System.exit(0);
        } else {
            mainFrame.dispose();
        }
    }

    public static void safeDisconnect() {
        BasicConnection con = remoteDir.getCon();
        if (con != null && con.isConnected()) {
            try {
                con.disconnect();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        FilesystemConnection c = new FilesystemConnection();
        c.addConnectionListener((ConnectionListener)((Object)remoteDir));
        remoteDir.setCon(c);
        if (!c.chdir("/")) {
            c.chdir("C:\\");
        }
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        localDir.actionPerformed(this, "local");
        remoteDir.actionPerformed(this, "remote");
        desktop.remove(this.background);
        this.addBackgroundImage();
        this.validate();
        System.out.println(StatusPanel.status);
        StatusPanel.status.fresh();
    }

    public void addBackgroundImage() {
        try {
            this.background = new HDesktopBackground(Settings.background, null);
            this.background.setBounds(0, 0, this.getSize().width, this.getSize().height);
            desktop.add((Component)this.background, new Integer(Integer.MIN_VALUE));
        }
        catch (Exception ex) {
            Log.out(Settings.background + " missing, no background image used");
        }
    }

    private static void compile() {
    }

    private static void setSocksProxyOptions(String proxy, String port) {
        if (proxy.equals("") || port.equals("")) {
            return;
        }
        Properties sysprops = System.getProperties();
        sysprops.remove("socksProxyHost");
        sysprops.remove("socksProxyPort");
        sysprops.put("socksProxyHost", proxy);
        sysprops.put("socksProxyPort", port);
        Log.out("socks proxy: " + sysprops.get("socksProxyHost") + ":" + sysprops.get("socksProxyPort"));
    }

    public static void main(String[] argv) {
        try {
            long start = System.currentTimeMillis();
            Log.out("starting up jftp...");
            JFtp.compile();
            System.setProperty("sshtools.logfile", Settings.appHomeDir + "log4.txt");
            if (Settings.autoUpdate) {
                JFtp.checkForUpgrade();
            }
            Settings.enableResuming = true;
            Settings.enableUploadResuming = true;
            Settings.noUploadResumingQuestion = false;
            JFtp.setSocksProxyOptions(Settings.getSocksProxyHost(), Settings.getSocksProxyPort());
            JFtp jftp = new JFtp(true);
            UIManager.getLookAndFeelDefaults().put("ClassLoader", jftp.getClass().getClassLoader());
            String tmp = Settings.getLookAndFeel();
            if (tmp != null) {
                jftp.setLookAndFeel(Settings.getLookAndFeel());
            } else {
                jftp.setLookAndFeel("net.sourceforge.mlf.metouia.MetouiaLookAndFeel");
            }
            if (Settings.getLookAndFeel() == null || !Settings.getLookAndFeel().equals("com.incors.plaf.kunststoff.KunststoffLookAndFeel")) {
                try {
                    Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
                    UIManager.installLookAndFeel("Kunststoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel");
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
            if (Settings.getLookAndFeel() == null || !Settings.getLookAndFeel().equals("net.sourceforge.mlf.metouia.MetouiaLookAndFeel")) {
                try {
                    Class.forName("net.sourceforge.mlf.metouia.MetouiaLookAndFeel");
                    UIManager.installLookAndFeel("Metouia", "net.sourceforge.mlf.metouia.MetouiaLookAndFeel");
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
            mainFrame = new JFrame();
            mainFrame.setLocation(Settings.getWindowLocation());
            mainFrame.setTitle("JFtp - The Java Network Browser - Version " + JFtp.getVersion());
            mainFrame.setResizable(Settings.resize);
            mainFrame.addWindowListener(jftp);
            Image icon = HImage.getImage(jftp, Settings.iconImage);
            mainFrame.setIconImage(icon);
            mainFrame.setFont(GUIDefaults.font);
            menuBar = new AppMenuBar(jftp);
            mainFrame.setJMenuBar(menuBar);
            mainFrame.getContentPane().setLayout(new BorderLayout());
            mainFrame.getContentPane().add("Center", jftp);
            SwingUtilities.updateComponentTreeUI(mainFrame);
            mainFrame.pack();
            mainFrame.validate();
            mainFrame.setVisible(true);
            if (argv.length > 0) {
                if (argv[0].indexOf("sftp:") >= 0) {
                    new SftpHostChooser().update(argv[0].replaceAll("sftp:", "ftp:"));
                } else {
                    jftp.hc.update(argv[0]);
                }
            }
            Log.out("jftp is up and running.");
            long end = System.currentTimeMillis();
            Log.out("startup time: " + (end - start) + "ms.");
        }
        catch (Error ex) {
            ex.printStackTrace();
        }
    }

    private void log(String msg) {
        if (msg.startsWith("200") || msg.startsWith("227") ? (msg.indexOf("NOOP") > 0 || msg.indexOf("Type") > 0 || msg.indexOf("MODE") > 0 || msg.indexOf("Passive") > 0) && Settings.hideStatus : log == null) {
            return;
        }
        if (!msg.equals("")) {
            this.buffer = this.buffer + " " + msg;
        }
        log.append(this.buffer);
        this.buffer = "";
        long time = System.currentTimeMillis();
        if (time - this.oldtime < (long)Settings.uiRefresh) {
            UpdateDaemon.updateLog();
            return;
        }
        this.oldtime = time;
        JScrollBar bar = logSp.getVerticalScrollBar();
        bar.setValue(bar.getMaximum());
        this.repaint();
        this.revalidate();
    }

    private void logRaw(String msg) {
        log.append(" " + msg);
        Log.out("NOTE: logRaw called");
        this.paintImmediately(0, 0, this.getSize().width, this.getSize().height);
    }

    public void clearLog() {
        log.setText("");
        logSp.paintImmediately(0, 0, JFtp.logSp.getSize().width, JFtp.logSp.getSize().height);
    }

    private void log(String msg, Throwable throwable) {
        PrintWriter p = new PrintWriter(new StringWriter());
        throwable.printStackTrace(p);
        this.log(msg);
        this.log(p.toString());
    }

    @Override
    public void debug(String msg) {
        this.log(msg + "\n");
    }

    @Override
    public void debugRaw(String msg) {
        this.logRaw(msg);
    }

    @Override
    public void debug(String msg, Throwable throwable) {
        this.log(msg, throwable);
    }

    @Override
    public void warn(String msg) {
        this.log(msg);
    }

    @Override
    public void warn(String msg, Throwable throwable) {
        this.log(msg, throwable);
    }

    @Override
    public void error(String msg) {
        this.log(msg);
    }

    @Override
    public void error(String msg, Throwable throwable) {
        this.log(msg, throwable);
    }

    @Override
    public void info(String msg) {
        this.log(msg);
    }

    @Override
    public void info(String msg, Throwable throwable) {
        this.log(msg, throwable);
    }

    @Override
    public void fatal(String msg) {
        this.log(msg);
    }

    @Override
    public void fatal(String msg, Throwable throwable) {
        this.log(msg, throwable);
    }

    public void debugSize(int size, boolean recv, boolean last, String file) {
    }

    public static String getVersion() {
        try {
            URL u = ClassLoader.getSystemResource("docs/readme");
            if (u == null) {
                u = HImage.class.getResource("/docs/readme");
            }
            DataInputStream i = new DataInputStream(u.openStream());
            String tmp = i.readLine();
            tmp = tmp.substring(tmp.lastIndexOf(">") + 1);
            tmp = tmp.substring(0, tmp.indexOf("<"));
            return tmp;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static void checkForUpgrade() {
        try {
            File dl;
            Log.out("Checking for updates...");
            URL u = ClassLoader.getSystemResource("docs/readme");
            if (u == null) {
                u = HImage.class.getResource("/docs/readme");
            }
            DataInputStream i = new DataInputStream(u.openStream());
            String tmp = i.readLine();
            tmp = tmp.substring(tmp.lastIndexOf(">"));
            tmp = tmp.substring(tmp.indexOf(".") + 1);
            tmp = tmp.substring(0, tmp.indexOf("<"));
            int x = Integer.parseInt(tmp) + 1;
            String nextVersion = "jftp-1.";
            if (x < 10) {
                nextVersion = nextVersion + "0";
            }
            if (!(dl = new File(nextVersion = nextVersion + x + ".tar.gz")).exists() || dl.length() <= 0L) {
                URL url = new URL("http://osdn.dl.sourceforge.net/sourceforge/j-ftp/" + nextVersion);
                BufferedOutputStream f = new BufferedOutputStream(new FileOutputStream(dl));
                BufferedInputStream in = new BufferedInputStream(url.openStream());
                byte[] buf = new byte[4096];
                int stat = 1;
                Log.out("\ndownloading update: " + dl.getAbsolutePath() + "\n\n");
                while (stat > 0 && (stat = in.read(buf)) != -1) {
                    f.write(buf, 0, stat);
                    System.out.print(".");
                }
                f.flush();
                f.close();
                in.close();
            }
            Log.out("\n\n\na newer version was found!\nplease install the File " + dl.getAbsolutePath() + " or even better visit the homepage to download the latest version...\n" + "you can turn this feature off if you don't like it (view readme for details)\n\nStarting anyway...\n\n");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Log.out("finished check...");
    }

    public static ConnectionHandler getConnectionHandler() {
        BasicConnection con = remoteDir.getCon();
        if (con != null && con instanceof FtpConnection) {
            return ((FtpConnection)con).getConnectionHandler();
        }
        return defaultConnectionHandler;
    }

    public void fireUpdate() {
        LocalIO.pause(200);
        this.repaint();
    }

    public void ensureLogging() {
        if (this.buffer.equals("")) {
            JScrollBar bar;
            if (logSp == null || (bar = logSp.getVerticalScrollBar()) == null || bar == null || bar.getValue() == bar.getMaximum() || bar.getValueIsAdjusting()) {
                return;
            }
            bar.setValue(bar.getMaximum());
            logSp.repaint();
            this.repaint();
            this.revalidate();
            return;
        }
        Log.out("flushing log buffer...");
        this.oldtime = 0L;
        this.log("");
    }

    public void setLookAndFeel(String name) {
        if (name == null) {
            return;
        }
        try {
            UIManager.setLookAndFeel(name);
            if (mainFrame != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SwingUtilities.updateComponentTreeUI(mainFrame);
                        SwingUtilities.updateComponentTreeUI(statusP);
                    }
                });
            }
        }
        catch (Exception ex) {
            Log.debug("Error setting look and feel: " + ex);
        }
    }

    public void addConnection(String name, BasicConnection con) {
        con.addConnectionListener((ConnectionListener)((Object)localDir));
        RemoteDir tmp = new RemoteDir();
        tmp.setDownloadList(dList);
        con.addConnectionListener(tmp);
        tmp.setCon(con);
        int x = this.remoteConnectionPanel.getSelectedIndex();
        this.remoteConnectionPanel.addTab(this.parse(name), null, tmp, "Switch to: " + this.parse(name));
        this.remoteConnectionPanel.setSelectedIndex(x + 1);
        this.j2.setClosable(true);
    }

    public void addLocalConnection(String name, BasicConnection con) {
        con.addConnectionListener((ConnectionListener)((Object)remoteDir));
        LocalDir tmp = new LocalDir();
        tmp.setDownloadList(dList);
        con.addConnectionListener(tmp);
        tmp.setCon(con);
        int x = this.localConnectionPanel.getSelectedIndex();
        this.localConnectionPanel.addTab(this.parse(name), null, tmp, "Switch to: " + this.parse(name));
        this.localConnectionPanel.setSelectedIndex(x + 1);
        this.j1.setClosable(true);
    }

    private String parse(String what) {
        if (what.indexOf("@") >= 0) {
            return what.substring(what.lastIndexOf("@") + 1);
        }
        return what;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        remoteDir = (Dir)((Object)this.remoteConnectionPanel.getSelectedComponent());
        localDir = (Dir)((Object)this.localConnectionPanel.getSelectedComponent());
        remoteDir.getCon().setLocalPath(localDir.getPath());
    }

    public void closeCurrentTab() {
        int x = this.remoteConnectionPanel.getSelectedIndex();
        if (x > 0) {
            JFtp.safeDisconnect();
            this.remoteConnectionPanel.remove(x);
            this.remoteConnectionPanel.setSelectedIndex(x - 1);
        }
        if (this.remoteConnectionPanel.getTabCount() < 2) {
            this.j2.setClosable(false);
        }
    }

    public void closeCurrentLocalTab() {
        int x = this.localConnectionPanel.getSelectedIndex();
        if (x > 0) {
            BasicConnection con = localDir.getCon();
            if (con != null && con.isConnected()) {
                try {
                    con.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.localConnectionPanel.remove(x);
            this.localConnectionPanel.setSelectedIndex(x - 1);
        }
        if (this.localConnectionPanel.getTabCount() < 2) {
            this.j1.setClosable(false);
        }
    }

    public void addToDesktop(String title, Component c, int w, int h) {
        JInternalFrame jt = new JInternalFrame(title, false, true, false, true);
        if (w < 500) {
            jt.setLocation(200, 100);
        } else {
            jt.setLocation(80, 100);
        }
        jt.getContentPane().add(c);
        desktop.add(jt);
        this.internalFrames.put("" + c.hashCode(), jt);
        jt.pack();
        jt.setSize(new Dimension(w, h));
        jt.show();
    }

    public void removeFromDesktop(int component) {
        JInternalFrame f = (JInternalFrame)this.internalFrames.get("" + component);
        if (f != null) {
            f.dispose();
        } else {
            Log.debug("ERROR: " + component + " not found in Hashtable!");
        }
    }

    public void setClosable(int component, boolean ok) {
        JInternalFrame f = (JInternalFrame)this.internalFrames.get("" + component);
        if (f != null) {
            f.setClosable(ok);
        } else {
            Log.debug("ERROR: " + component + " not found in Hashtable!");
        }
    }

    public void setLocation(int component, int x, int y) {
        JInternalFrame f = (JInternalFrame)this.internalFrames.get("" + component);
        if (f != null) {
            f.setLocation(x, y);
        } else {
            Log.debug("ERROR: " + component + " not found in Hashtable!");
        }
    }

    public static void updateMenuBar() {
        menuBar.resetFileItems();
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (e.getSource() == this.j1) {
            this.closeCurrentLocalTab();
        } else if (e.getSource() == this.j2) {
            this.closeCurrentTab();
        }
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    public void drop() {
        try {
            this.handleDrop(null, Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void handleDrop(DropTargetDropEvent e, Transferable t) throws Exception {
        System.out.println("Starting dropAttempt");
        DataFlavor chosen = DataFlavor.javaFileListFlavor;
        DataFlavor second = FileTransferable.plainTextFlavor;
        DataFlavor flavor = null;
        Object data = null;
        if (e != null) {
            flavor = e.getCurrentDataFlavors()[0];
            e.acceptDrop(acceptableActions);
            Class<?> c = flavor.getDefaultRepresentationClass();
        }
        if (flavor == null) {
            flavor = second;
        }
        String name = "";
        if (t.isDataFlavorSupported(chosen)) {
            System.out.println("Using List DnD style");
            List myList = (List)t.getTransferData(chosen);
            File[] f = (File[])myList.toArray();
            for (int i = 0; i < f.length; ++i) {
                name = f[i].getAbsolutePath();
                System.out.println("DnD file: " + name);
            }
            this.draggedTransfer(f, name);
        } else if (t.isDataFlavorSupported(second)) {
            System.out.println("Using text/plain DnD style");
            data = t.getTransferData(flavor);
            String str = "";
            int i = 0;
            if (data instanceof Reader) {
                int c;
                while ((c = ((Reader)data).read()) != -1) {
                    if (i == 1 && c == 0) {
                        i = -1;
                    } else {
                        str = str + new Character((char)c).toString();
                    }
                    ++i;
                }
            } else {
                str = "" + data;
            }
            System.out.println("Object data: \"" + str + "\"");
            if (str.startsWith("<")) {
                Log.debug("Mozilla DnD detected (preparsing)");
                str = str.substring(str.indexOf("\"") + 1);
                str = str.substring(0, str.indexOf("\""));
                Log.debug("Parsed data: " + str);
            }
            if (str.indexOf("[") >= 0) {
                Log.debug("Windows DnD detected");
                name = str.substring(str.indexOf("[") + 1);
                name = name.substring(0, name.lastIndexOf("]"));
            } else if (new String(str).startsWith("file://")) {
                name = str.substring(7);
                Log.debug("File URL DnD detected: " + name);
            }
            if (!new File(name).exists()) {
                System.out.println("No file string in clipboard: " + name);
                return;
            }
            System.out.println("DnD file: " + name);
            File[] f1 = new File[]{new File(name)};
            this.draggedTransfer(f1, name);
        }
    }

    private void draggedTransfer(File[] f, String name) {
        if (f.length == 1 && f[0].isFile()) {
            String path = "";
            if (name.indexOf("/") >= 0) {
                path = name.substring(0, name.lastIndexOf("/") + 1);
                name = name.substring(name.lastIndexOf("/") + 1);
            }
            Log.debug("DnD: " + path + " -> " + name);
            if (!path.trim().equals("")) {
                ((LocalDir)localDir).chdir(path);
            }
            ((LocalDir)localDir).startTransfer(new DirEntry(name, (ActionListener)((Object)localDir)));
        } else {
            Log.debug("Dragging multiple files or dirs is not yet supported.");
        }
    }

    static {
        statusL = new JLabel("Welcome to JFtp...                                                            ");
        dList = new DownloadList();
        dQueue = new DownloadQueue();
        uiBlocked = false;
        hostinfo = new HostInfo();
        defaultConnectionHandler = new ConnectionHandler();
        desktop = new JDesktopPane();
        menuBar = null;
        acceptableActions = 1;
    }

    class DTListener
    implements DropTargetListener {
        DTListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(acceptableActions);
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            e.acceptDrag(acceptableActions);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
            e.acceptDrag(acceptableActions);
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            try {
                JFtp.this.handleDrop(e, e.getTransferable());
                e.dropComplete(true);
                UpdateDaemon.updateRemoteDir();
            }
            catch (Throwable t) {
                t.printStackTrace();
                e.dropComplete(false);
                return;
            }
        }
    }
}

