/*
    Copyright (C) 2008 Fons Adriaensen <fons@kokkinizita.net>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include "styles.h"


XftColor        *XftColors [NXFTCOLORS];


XftColor *blackorwhite (XftColor *C)
{
    float v;

    v = 0.23f * C->color.red + 0.70f * C->color.green + 0.07f * C->color.blue;
    return (v > 25e3f) ? XftColors [C_BLACK] : XftColors [C_WHITE];
}


void styles_init (X_display *disp, X_resman *xrm)
{
    XftColors [C_BLACK]    = disp->alloc_xftcolor ("black", 0);
    XftColors [C_WHITE]    = disp->alloc_xftcolor ("white", 0);
    XftColors [C_MAIN_BG]  = disp->alloc_xftcolor (xrm->get (".color.main.bg",   "gray40" ),  0);
    XftColors [C_MAIN_FG]  = disp->alloc_xftcolor (xrm->get (".color.main.fg",   "white"  ),  0);
    XftColors [C_MAIN_LS]  = disp->alloc_xftcolor (xrm->get (".color.main.ls",   "gray50"),   0);
    XftColors [C_MAIN_DS]  = disp->alloc_xftcolor (xrm->get (".color.main.ds",   "black"),    0);
    XftColors [C_TEXT_BG]  = disp->alloc_xftcolor (xrm->get (".color.text.bg",   "white"),    0);
    XftColors [C_TEXT_FG]  = disp->alloc_xftcolor (xrm->get (".color.text.fg",   "black"  ),  0);
    XftColors [C_TEXT_HL]  = disp->alloc_xftcolor (xrm->get (".color.text.hl",   "#c0ffa0"),  0);
    XftColors [C_TEXT_CA]  = disp->alloc_xftcolor (xrm->get (".color.text.ca",   "red"),      0);
    XftColors [C_TEXT_GR]  = disp->alloc_xftcolor (xrm->get (".color.text.gr",   "gray80"),   0);
    XftColors [C_TEXT_MO]  = disp->alloc_xftcolor (xrm->get (".color.text.mo",   "#e0e0c0"),  0);
    XftColors [C_TEXT_ER]  = disp->alloc_xftcolor (xrm->get (".color.text.er",   "orange"),   0);
    XftColors [C_VUM1]     = disp->alloc_xftcolor (xrm->get (".color.vum1",      "#000000"),  0);
    XftColors [C_VUML]     = disp->alloc_xftcolor (xrm->get (".color.vuml",      "#ff0000"),  0);
    XftColors [C_VUMR]     = disp->alloc_xftcolor (xrm->get (".color.vumr",      "#00a000"),  0);
    XftColors [C_PPM1]     = disp->alloc_xftcolor (xrm->get (".color.ppm1",      "#ffffff"),  0);
    XftColors [C_PPML]     = disp->alloc_xftcolor (xrm->get (".color.ppml",      "#ff0000"),  0);
    XftColors [C_PPMR]     = disp->alloc_xftcolor (xrm->get (".color.ppmr",      "#00ff00"),  0);
}


void styles_fini (X_display *disp)
{
}
