/*
 * @(#)CMLHandler.java   0.2 2000/01/06
 *
 * Information can be found at http://openscience.chem.nd.edu/~egonw/cml/
 *
 * Copyright (c) 2000 E.L. Willighagen (egonw@sci.kun.nl)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 **/

package org.openscience.cml;

import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Vector;
import org.openscience.cdopi.CDOInterface;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;

public class CMLHandler extends HandlerBase
{
    private Convention conv;
    private int debug;

    private Hashtable userConventions;

    public CMLHandler(CDOInterface cdo) {
        debug = 0;
        conv = new Convention(cdo);
        userConventions = new Hashtable();
    }

    public void registerConvention(String convention, Convention conv) {
      userConventions.put(convention, conv);
    }

    public void setDebug() {
      this.debug = 1;
    }

    public void characters(char ch[], int start, int length) {
       println("CMLHandler: character data"); 
       conv.characterData(ch, start, length);
    }

    public void doctypeDecl(String name, String publicId, String systemId) throws Exception {}

    public void endDocument() {
        conv.endDocument();
    }

    public void endElement(String name) {
       println("CMLHandler: end element"); 
       conv.endElement(name);
    }

    public CDOInterface returnCDO() {
        return conv.returnCDO();
    }

    public void startDocument() {
        conv.startDocument();
    }

    public void startElement(String name, AttributeList atts) {
        println("CMLHandler: start element -> " + name); 
        for (int i = 0; i < atts.getLength(); i++)
        {
            if (atts.getName(i).equals("convention"))
            {
                println(new StringBuffer("New Convention: ").append(atts.getValue(i)).toString());
                if (atts.getValue(i).equals("CML")) {
                    println("Doing nothing");
                } else if (atts.getValue(i).equals("PDB")) {
                    conv = new PDBConvention(conv);
		    if (debug == 1) conv.setDebug();
                } else if (atts.getValue(i).equals("MDLMol")) {
		    println("MDLMolConvetion instantiated...");
                    conv = new MDLMolConvention(conv);
		    if (debug == 1) conv.setDebug();
                } else {
                    //unknown convention. userConvention?
                    if (userConventions.containsKey(atts.getValue(i))) {
                      Convention newconv = (Convention)userConventions.get(atts.getValue(i));
                      newconv.inherit(conv);
                      conv = newconv;
	  	      if (debug == 1) conv.setDebug();
                    }
                }                 
            }
        }
        conv.startElement(name, atts);
    }

    private void println(String s) {
      if (this.debug == 1) System.out.println(s);
    }
}
