/*
 * @(#)MDLMolConvention.java   0.2 2000/12/18
 *
 * Information can be found at http://openscience.chem.nd.edu/~egonw/cml/
 *
 * Copyright (c) 2000 E.L. Willighagen (egonw@sci.kun.nl)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 **/
 
/*** 
 *  Implementation of the MDLMol Covention for CML.
 */

package org.openscience.cml;

import java.util.*;
import org.xml.sax.*;
import com.microstar.xml.*;
import org.openscience.cdopi.*;

public class MDLMolConvention extends Convention {

    public MDLMolConvention(CDOInterface cdo) {
	super(cdo);
    };
  
    public MDLMolConvention(Convention conv) {
	super(conv);
    }
    
    public CDOInterface returnCDO() {
	return this.cdo;
    };
  
    public void startDocument() {
	super.startDocument();
	cdo.startObject("Frame");
    };

    public void endDocument() {
	cdo.endObject("Frame");
	super.endDocument();
    };
    
    
    public void startElement (String name, AttributeList atts) {
        warn("MDLMol element: name");	
	super.startElement(name, atts);
    };

    public void endElement (String name) {
	super.endElement(name);
    }

    public void characterData (char ch[], int start, int length) {
	String s = toString(ch, start, length).trim();
	if (CurrentElement == STRING && BUILTIN.equals("stereo")) {
	    stereoGiven = true;
	    if (s.trim().equals("W")) {
		warn("CML W stereo found");
		bondStereo.addElement("1");
	    } else if (s.trim().equals("H")) {
		warn("CML H stereo found");
		bondStereo.addElement("6");
	    }
	} else {           
	    super.characterData(ch, start, length);
	}
    }
}
