#include <jmp-config.h>

#include <stdio.h>
#include <stdlib.h>

#include <jmp.h>
#include <hash.h>
#include <comparators.h>
#include <stats_context.h>
#include <stats_personality.h>

#include <ui_file.h>


void dump_classes (hashtab* classes, FILE *f) {
    stats_context_t stats_context;

    stats_context_init (&stats_context, &stats_personality_class_usage);
    stats_context_set_compr (&stats_context, cls_compr_size);

    /* Single pass filter, count and copy (with total) to expandable arraylist datums */
    stats_context_calc (&stats_context, classes);

    fprintf (f, "Classdump\n");
    fprintf (f, "class_name\t#instaces\tmax #instances\tsize\t#GC\ttenure\n");
    fprintf (f, "--------------------------------------------------------------\n");
    {
        cls **classlist = (cls **)stats_context.resultlist;
        int i;
        for (i = 0; i < stats_context.resultlist_count; i++) 
            dump_class_row (classlist[i], f);	
    }

    stats_context_end (&stats_context);
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
