/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.awt.Dimension;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.fest.util.Arrays;
import org.fest.util.Collections;
import org.fest.util.Maps;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Formatting {
    private static final String EMPTY_MESSAGE = "";

    static String format(String message) {
        if (Strings.isEmpty((String)message)) {
            return EMPTY_MESSAGE;
        }
        return Strings.concat((Object[])new Object[]{"[", message, "] "});
    }

    static String inBrackets(Object o) {
        if (Formatting.isOneDimensionalArray(o)) {
            return Formatting.doBracketAround(Arrays.format((Object)o));
        }
        if (o instanceof Class) {
            return Formatting.doBracketAround((Class)o);
        }
        if (o instanceof Collection) {
            return Formatting.doBracketAround((Collection)o);
        }
        if (o instanceof Map) {
            return Formatting.doBracketAround((Map)o);
        }
        if (o instanceof File) {
            return Formatting.doBracketAround((File)o);
        }
        if (o instanceof Dimension) {
            return Formatting.doBracketAround((Dimension)o);
        }
        return Formatting.doBracketAround(Strings.quote((Object)o));
    }

    private static boolean isOneDimensionalArray(Object o) {
        return o != null && o.getClass().isArray() && !o.getClass().getComponentType().isArray();
    }

    private static String doBracketAround(Class<?> c) {
        return Formatting.doBracketAround(c.getName());
    }

    private static String doBracketAround(Collection<?> c) {
        return Formatting.doBracketAround(Collections.format(c));
    }

    private static String doBracketAround(Map<?, ?> m) {
        return Formatting.doBracketAround(Maps.format(m));
    }

    private static String doBracketAround(File f) {
        return Formatting.doBracketAround(f.getAbsolutePath());
    }

    private static String doBracketAround(Dimension d) {
        return Formatting.doBracketAround(Strings.concat((Object[])new Object[]{"(", d.width, ", ", d.height, ")"}));
    }

    private static String doBracketAround(Object o) {
        return Strings.concat((Object[])new Object[]{"<", o, ">"});
    }

    private Formatting() {
    }
}

