/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.innerclass;

import org.fest.reflect.innerclass.Invoker;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StaticInnerClassName {
    private final String name;

    public StaticInnerClassName(String name) {
        if (name == null) {
            throw new NullPointerException("The name of the static inner class to access should not be null");
        }
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("The name of the static inner class to access should not be empty");
        }
        this.name = name;
    }

    public Invoker in(Class<?> declaringClass) {
        if (declaringClass == null) {
            throw new NullPointerException("The declaring class should not be null");
        }
        return new Invoker(declaringClass, this.name);
    }
}

