/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.lang.reflect.Array;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Arrays {
    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T[] array(T ... values) {
        return values;
    }

    public static String format(Object array) {
        if (array == null) {
            return null;
        }
        Class<?> type = array.getClass();
        if (!type.isArray() || type.getComponentType().isArray()) {
            return null;
        }
        int length = Array.getLength(array) - 1;
        if (length == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(Strings.quote(Array.get(array, i)));
            if (i == length) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private Arrays() {
    }
}

