/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.extensions.xml.XMLConstants;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class XMLUtil
implements XMLConstants {
    private XMLUtil() {
    }

    public static String getAttribute(Element element, String name) {
        String value = element.getAttribute(name);
        if (value != null && value.length() > 0) {
            return value;
        }
        return null;
    }

    public static boolean getBooleanAttributeValue(Element element, String name) {
        String value = element.getAttribute(name);
        return new Boolean(value);
    }

    public static String getName(Node node) {
        String name = null;
        if (node instanceof Element) {
            name = XMLUtil.getAttribute((Element)node, "name");
        }
        if (name != null) {
            return name;
        }
        return node.getNodeName();
    }

    public static String getPath(Node node) {
        StringBuffer buf = new StringBuffer(500);
        if (node.getParentNode() != null && node.getParentNode() instanceof Element) {
            buf.append(XMLUtil.getPath(node.getParentNode()));
            buf.append(".");
        }
        buf.append(XMLUtil.getName(node));
        return buf.toString();
    }

    public static String getURLFromClassPath(String file) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(file);
        if (url != null) {
            return url.toString();
        }
        return new File(file).getAbsolutePath();
    }

    public static boolean hasAttribute(Element element, String name) {
        return element.hasAttribute(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document parse(InputStream stream) {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            try {
                document = factory.newDocumentBuilder().parse(stream);
                Object var5_6 = null;
                if (stream == null) return document;
            }
            catch (SAXException sxe) {
                Exception x = sxe;
                if (sxe.getException() != null) {
                    x = sxe.getException();
                }
                x.printStackTrace();
                throw new RuntimeException(x.toString());
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
                throw new XMLException("Parser configuration exception.");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw new XMLException("IO Exception while parsing XML doc.");
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (stream == null) throw throwable;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new XMLException("IO Exception while closing stream: " + ex);
            }
        }
        try {}
        catch (IOException ex) {
            throw new XMLException("IO Exception while closing stream: " + ex);
        }
        stream.close();
        return document;
    }

    public static InputStream readFileFromClassContext(Class clz, String fileName) {
        return clz.getResourceAsStream(fileName);
    }

    public static InputStream readFileFromClasspath(String fileName) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
        if (is == null) {
            try {
                return new FileInputStream(fileName);
            }
            catch (FileNotFoundException ex) {
                throw new RuntimeException("Could not open input file:" + fileName);
            }
        }
        return is;
    }

    public static void writeFile(String encoding, OutputStream strm, Document doc) throws UnsupportedEncodingException {
        XMLWriter wr = new XMLWriter(false);
        wr.setOutput(strm, encoding);
        wr.write(doc);
    }
}

