/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import java.awt.Point;
import java.text.MessageFormat;
import java.text.ParseException;
import junit.extensions.xml.IXMLTest;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.IXMLTestSuite;
import junit.extensions.xml.XMLConstants;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLUtil;
import junit.framework.TestCase;
import org.w3c.dom.Element;

public abstract class AbstractTagHandler
implements XMLConstants {
    private Element m_element;
    private IXMLTestCase m_testCase;
    private IXMLTestSuite m_testSuite;

    public AbstractTagHandler(Element element, IXMLTestCase testCase) {
        if (element == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        if (testCase == null) {
            throw new IllegalArgumentException("testCase must not be null");
        }
        this.m_element = element;
        this.m_testCase = testCase;
    }

    public AbstractTagHandler(Element element, IXMLTestSuite testSuite) {
        if (element == null) {
            throw new IllegalArgumentException("Element must not be null");
        }
        if (testSuite == null) {
            throw new IllegalArgumentException("testSuite must not be null");
        }
        this.m_element = element;
        this.m_testSuite = testSuite;
    }

    public final Element getElement() {
        return this.m_element;
    }

    public final TestCase getTestCase() {
        return (TestCase)this.m_testCase;
    }

    public final IXMLTestCase getXMLTestCase() {
        return this.m_testCase;
    }

    public final IXMLTestSuite getXMLTestSuite() {
        return this.m_testSuite;
    }

    public abstract void processElement() throws XMLException;

    protected final String getTagName() {
        return this.m_element.getTagName();
    }

    protected final void checkAtLeastOneRequiredAttribute(String[] attrName) throws XMLException {
        this.checkAtLeastOneRequiredAttribute(this.getElement(), attrName);
    }

    protected final void checkAtLeastOneRequiredAttribute(Element root, String[] attrName) throws XMLException {
        int found = 0;
        for (int i = 0; i < attrName.length; ++i) {
            if (!XMLUtil.hasAttribute(root, attrName[i])) continue;
            ++found;
        }
        if (found == 0) {
            String buf = "";
            for (int i = 0; i < attrName.length; ++i) {
                buf = MessageFormat.format("{0} {1}", buf, attrName[i]);
            }
            throw new XMLException(root.getNodeName() + " is missing one of the required attributes: " + buf, null, root, this.getTest().getPropertyCache());
        }
    }

    protected final void checkElementTagName(String expectedName) throws XMLException {
        if (!expectedName.equals(this.m_element.getTagName())) {
            throw new XMLException("Cannot process " + this.getElement().getTagName() + " node, expected '" + expectedName + "'", null, this.getElement(), this.getTest().getPropertyCache());
        }
    }

    protected final void checkRequiredAttribute(Element e, String attrName) throws XMLException {
        if (!XMLUtil.hasAttribute(e, attrName)) {
            throw new XMLException("Missing the required attribute: " + attrName + " in element: " + this.m_element.getNodeName(), null, e, this.getTest().getPropertyCache());
        }
    }

    protected final void checkRequiredAttribute(String attrName) throws XMLException {
        this.checkRequiredAttribute(this.getElement(), attrName);
    }

    protected boolean getBoolean(String attributeName) {
        return this.getBoolean(this.getElement(), attributeName, false);
    }

    protected boolean getBoolean(String attributeName, boolean defaultValue) {
        return this.getBoolean(this.getElement(), attributeName, defaultValue);
    }

    protected final boolean getBoolean(Element e, String attributeName) {
        return this.getBoolean(e, attributeName, false);
    }

    protected final boolean getBoolean(Element e, String attributeName, boolean defaultValue) {
        if (XMLUtil.hasAttribute(e, attributeName)) {
            String s = this.getString(e, attributeName);
            if (defaultValue) {
                return !"false".equalsIgnoreCase(s);
            }
            return "true".equalsIgnoreCase(s);
        }
        return defaultValue;
    }

    protected int getInt(String attributeName, int defaultValue) {
        return this.getInt(this.getElement(), attributeName, defaultValue);
    }

    protected int getInt(Element e, String attributeName, int defaultValue) {
        String s = this.getString(e, attributeName);
        try {
            if (s != null) {
                return Integer.parseInt(s);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return defaultValue;
    }

    protected long getLong(String attributeName, long defaultValue) {
        return this.getLong(this.getElement(), attributeName, defaultValue);
    }

    protected long getLong(Element e, String attributeName, long defaultValue) {
        String s = this.getString(e, attributeName);
        try {
            if (s != null) {
                return Long.parseLong(s);
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return defaultValue;
    }

    protected final Point getPoint(String attributeName, Point defaultValue) throws XMLException {
        return this.getPoint(this.getElement(), attributeName, defaultValue);
    }

    protected final Point getPoint(Element e, String attributeName, Point defaultValue) throws XMLException {
        String s = this.getString(e, attributeName);
        if (s == null) {
            return defaultValue;
        }
        MessageFormat mf = new MessageFormat("{0},{1}");
        int x = 0;
        int y = 0;
        try {
            Object[] obs = mf.parse(s);
            x = Integer.parseInt((String)obs[0]);
            y = Integer.parseInt((String)obs[1]);
        }
        catch (NumberFormatException ex) {
            throw new XMLException("Invalid number format:" + s, (Throwable)ex, e, this.getTest().getPropertyCache());
        }
        catch (ParseException ex) {
            throw new XMLException("Parsing of Point failed." + s, (Throwable)ex, e, this.getTest().getPropertyCache());
        }
        return new Point(x, y);
    }

    protected final String getString(String attributeName) {
        return this.getString(this.getElement(), attributeName);
    }

    protected final String getString(String attributeName, String defaultValue) {
        return this.getString(this.getElement(), attributeName, defaultValue);
    }

    protected final String getString(Element e, String attributeName) {
        String s = XMLUtil.getAttribute(e, attributeName);
        return this.resolveVariables(s);
    }

    protected final String getString(Element e, String attributeName, String defaultValue) {
        if (e.hasAttribute(attributeName)) {
            return this.getString(e, attributeName);
        }
        return this.resolveVariables(defaultValue);
    }

    protected void checkOneRequiredAttribute(String[] attrName) throws XMLException {
        this.checkOneRequiredAttribute(this.getElement(), attrName);
    }

    protected void checkOneRequiredAttribute(Element root, String[] attrName) throws XMLException {
        int found = 0;
        if (attrName != null) {
            for (int i = 0; i < attrName.length; ++i) {
                if (!XMLUtil.hasAttribute(root, attrName[i])) continue;
                ++found;
            }
        }
        if (found == 0) {
            String buf = "";
            for (int i = 0; i < attrName.length; ++i) {
                buf = MessageFormat.format("{0} {1}", buf, attrName[i]);
            }
            throw new XMLException(root.getNodeName() + " is missing one of the required attributes: " + buf, null, root, this.getTest().getPropertyCache());
        }
        if (found > 1) {
            String buf = "";
            for (int i = 0; i < attrName.length; ++i) {
                buf = MessageFormat.format("{0} {1}", buf, attrName[i]);
            }
            throw new XMLException("Too many attributes of:" + buf, null, root, this.getTest().getPropertyCache());
        }
    }

    protected final String resolveVariables(String s) {
        if (this.getXMLTestCase() != null) {
            return this.getXMLTestCase().resolveProperties(s);
        }
        if (this.getXMLTestSuite() != null) {
            return this.getXMLTestSuite().resolveProperties(s);
        }
        return s;
    }

    protected IXMLTest getTest() {
        if (this.m_testCase != null) {
            return this.m_testCase;
        }
        return this.m_testSuite;
    }

    protected void validateElement() throws XMLException {
        if (this.m_element == null) {
            throw new XMLException("Element could not be found.", null, this.getElement(), this.getTest().getPropertyCache());
        }
    }
}

