/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JComboBox;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.driver.JComboBoxSelectedItemQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;

final class JComboBoxSelectionValueQuery {
    static final Object NO_SELECTION_VALUE = new Object();

    @RunsInEDT
    static Object selection(final JComboBox comboBox, final JComboBoxCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Object>(){

            @Override
            protected Object executeInEDT() {
                if (comboBox.isEditable()) {
                    return JComboBoxSelectionValueQuery.selectionInEditableComboBox(comboBox);
                }
                int selectedIndex = comboBox.getSelectedIndex();
                if (selectedIndex == -1) {
                    return NO_SELECTION_VALUE;
                }
                return cellReader.valueAt(comboBox, selectedIndex);
            }
        });
    }

    @RunsInCurrentThread
    private static Object selectionInEditableComboBox(JComboBox comboBox) {
        Object selectedItem = JComboBoxSelectedItemQuery.selectedItemOf(comboBox);
        if (selectedItem == null) {
            return NO_SELECTION_VALUE;
        }
        return selectedItem.toString();
    }

    private JComboBoxSelectionValueQuery() {
    }
}

