/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.awt.AWT;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.driver.JListCellBoundsQuery;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.util.Objects;

final class JListMatchingItemQuery {
    @RunsInEDT
    static Point centerOfMatchingItemCell(final JList list, final String value, final JListCellReader cellReader) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                int itemIndex = JListMatchingItemQuery.matchingItemIndex(list, value, cellReader);
                return AWT.centerOf(JListCellBoundsQuery.cellBounds(list, itemIndex));
            }
        });
    }

    @RunsInCurrentThread
    static int matchingItemIndex(JList list, String value, JListCellReader cellReader) {
        int size = list.getModel().getSize();
        for (int i = 0; i < size; ++i) {
            if (!Objects.areEqual((Object)value, (Object)cellReader.valueAt(list, i))) continue;
            return i;
        }
        return -1;
    }

    private JListMatchingItemQuery() {
    }
}

