/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.util.Arrays;

final class JTreeExpandPathTask {
    @RunsInEDT
    static void expandPath(final JTree tree, final TreePath path) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                TreePath realPath = path;
                if (path.getPathCount() == 1 && !tree.isRootVisible()) {
                    Object root = tree.getModel().getRoot();
                    Object target = path.getLastPathComponent();
                    if (target != root) {
                        realPath = new TreePath(Arrays.array((Object[])new Object[]{root, target}));
                    }
                }
                if (!tree.isExpanded(path)) {
                    tree.expandPath(realPath);
                }
            }
        });
    }

    private JTreeExpandPathTask() {
    }
}

