/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.edt;

import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import org.fest.reflect.core.Reflection;
import org.fest.swing.exception.EdtViolationException;
import org.jdesktop.swinghelper.debug.CheckThreadViolationRepaintManager;

public class FailOnThreadViolationRepaintManager
extends CheckThreadViolationRepaintManager {
    public static FailOnThreadViolationRepaintManager install() {
        Object m = FailOnThreadViolationRepaintManager.currentRepaintManager();
        if (m instanceof FailOnThreadViolationRepaintManager) {
            return (FailOnThreadViolationRepaintManager)((Object)m);
        }
        return FailOnThreadViolationRepaintManager.installNew();
    }

    private static Object currentRepaintManager() {
        try {
            return Reflection.staticMethod((String)"appContextGet").withReturnType(Object.class).withParameterTypes(new Class[]{Object.class}).in(SwingUtilities.class).invoke(new Object[]{RepaintManager.class});
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private static FailOnThreadViolationRepaintManager installNew() {
        FailOnThreadViolationRepaintManager m = new FailOnThreadViolationRepaintManager();
        FailOnThreadViolationRepaintManager.setCurrentManager((RepaintManager)((Object)m));
        return m;
    }

    public FailOnThreadViolationRepaintManager() {
    }

    public FailOnThreadViolationRepaintManager(boolean completeCheck) {
        super(completeCheck);
    }

    protected void violationFound(JComponent c, StackTraceElement[] stackTraceElements) {
        EdtViolationException e = new EdtViolationException("EDT violation detected");
        if (stackTraceElements != null) {
            e.setStackTrace(stackTraceElements);
        }
        throw e;
    }
}

