/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.JPopupMenu;
import javax.swing.JTree;
import org.fest.swing.cell.JTreeCellReader;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JTreeDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.timing.Timeout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeFixture
extends JPopupMenuInvokerFixture<JTree>
implements CommonComponentFixture {
    private JTreeDriver driver;

    public JTreeFixture(Robot robot, JTree target) {
        super(robot, target);
        this.createDriver();
    }

    public JTreeFixture(Robot robot, String treeName) {
        super(robot, treeName, JTree.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new JTreeDriver(this.robot));
    }

    void updateDriver(JTreeDriver newDriver) {
        this.driver = newDriver;
    }

    @Override
    public JTreeFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JTreeFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JTreeFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JTreeFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JTreeFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    public JTreeFixture drag(int row) {
        this.driver.drag((JTree)this.target, row);
        return this;
    }

    public JTreeFixture drag(String path) {
        this.driver.drag((JTree)this.target, path);
        return this;
    }

    public JTreeFixture drop(int row) {
        this.driver.drop((JTree)this.target, row);
        return this;
    }

    public JTreeFixture drop(String path) {
        this.driver.drop((JTree)this.target, path);
        return this;
    }

    public JTreeFixture selectPath(String path) {
        this.driver.selectPath((JTree)this.target, path);
        return this;
    }

    public JTreeFixture selectPaths(String ... paths) {
        this.driver.selectPaths((JTree)this.target, paths);
        return this;
    }

    public JTreeFixture selectRow(int row) {
        this.driver.selectRow((JTree)this.target, row);
        return this;
    }

    public JTreeFixture selectRows(int ... rows) {
        this.driver.selectRows((JTree)this.target, rows);
        return this;
    }

    public JTreeFixture toggleRow(int row) {
        this.driver.toggleRow((JTree)this.target, row);
        return this;
    }

    public JPopupMenuFixture showPopupMenuAt(int row) {
        JPopupMenu popupMenu = this.driver.showPopupMenu((JTree)this.target, row);
        return new JPopupMenuFixture(this.robot, popupMenu);
    }

    public JPopupMenuFixture showPopupMenuAt(String path) {
        JPopupMenu popupMenu = this.driver.showPopupMenu((JTree)this.target, path);
        return new JPopupMenuFixture(this.robot, popupMenu);
    }

    @Override
    public JTreeFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JTreeFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JTreeFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JTreeFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JTreeFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JTreeFixture requireFocused() {
        this.driver.requireFocused(this.target);
        return this;
    }

    @Override
    public JTreeFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JTreeFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JTreeFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JTreeFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JTreeFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    public JTreeFixture requireEditable() {
        this.driver.requireEditable((JTree)this.target);
        return this;
    }

    public JTreeFixture requireNotEditable() {
        this.driver.requireNotEditable((JTree)this.target);
        return this;
    }

    public JTreeFixture requireSelection(String ... paths) {
        this.driver.requireSelection((JTree)this.target, paths);
        return this;
    }

    public JTreeFixture requireSelection(int ... rows) {
        this.driver.requireSelection((JTree)this.target, rows);
        return this;
    }

    public JTreeFixture requireNoSelection() {
        this.driver.requireNoSelection((JTree)this.target);
        return this;
    }

    public String separator() {
        return this.driver.separator();
    }

    public JTreeFixture separator(String separator) {
        this.driver.separator(separator);
        return this;
    }

    public JTreeFixture cellReader(JTreeCellReader cellReader) {
        this.driver.cellReader(cellReader);
        return this;
    }
}

