/* bprefs.h
 *
 * Copyright (C) 2002 by Jason Day
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __BPREFS_H__
#define __BPREFS_H__

/* preferences constants */
#define PREFS_FILE "backup.rc"

#define BPREF_BACKUP_WHEN        0
#define BPREF_BACKUP_NEW         1
#define BPREF_NUM_ARCHIVES       2
#define BPREF_PERSISTENT_ARCHIVE 3


/* max possible number of archive directories */
#define MAX_ARCHIVES 99


void backup_prefs_init (void);
int backup_get_pref (int which, long *n, const char **string);
int backup_set_pref (int which, long n, const char *string);
int backup_load_prefs (void);
int backup_save_prefs (void);
void backup_free_prefs (void);

#endif /* __BPREFS_H__ */
