import MySQLdb
import jppy
import string
import types

class bugzilla(jppy.conduit):

    bug_status_in = "('UNCONFIRMED','NEW','ASSIGNED','REOPENED')"

    def log(self,str,sd=None):
        jppy.log("bugzilla: %s" % str,sd=sd)
    
    def __init__(self, url, db, host, user, passwd, email, category_name):
        self.url = url
        self.sync_completed = None        
        self.db = db
        self.host = host
        self.user = user
        self.passwd = passwd
        if type(email) == types.StringType:
            self.email = [email]
        else:
            self.email = email            
        self.category_name = category_name
        self.tasklist = jppy.taskList()

    def pre_sync(self):
        self.log("Connecting to bugzilla database")        
        try:
            self.sqlcon = MySQLdb.connect(db=self.db,host=self.host,
                                          user=self.user,passwd=self.passwd,
                                          connect_timeout=15)
        except MySQLdb.OperationalError, e:
            self.log(e)
            return
        self.log("Connected")
        self.sqlcurs = self.sqlcon.cursor()

        self.sqlcurs.execute(
            "SELECT userid FROM profiles WHERE login_name in (%s)" %
            string.join(["'%s'" % address for address in self.email],", "))
        r = self.sqlcurs.fetchall()
        if len(r) < 1:
            self.log("Unknown user(s) %s to bugzilla" % self.email)
            return
        self.userids = []
        for row in r:
            self.userids.append(str(row[0]))
        self.log("Found userids to be %s" % self.userids)

        try:
            self.cat = self.tasklist.getCategories().index(self.category_name)
        except ValueError:
            self.log("Unknown category name %s" % self.category_name)
            return
        self.log("Found Todo category %s: number %d" % (self.category_name,
                                                        self.cat))
 
        self.sqlcurs.execute("""
            SELECT bug_id, bug_severity, bug_status, short_Desc,
                   priority, product, login_name as reporter_name, component,
                   resolution
            FROM bugs, profiles
            WHERE
                reporter=userid
                AND
                assigned_to in (%s) and bug_status in %s""" % (
                string.join(self.userids,", "),
                self.bug_status_in))
        r = self.sqlcurs.fetchall()

        # we have the data for the new records at this point, so we can
        # delete the old ones safely.

        self.log("Deleting old records")
        for todo in self.tasklist.records(categories=[self.cat]):
            self.log("Deleting %s" % todo)
            self.tasklist.delete(todo)

        self.log("Writing new records")        
        for bug in r:
            bug_id, bug_severity, bug_status, short_Desc, priority, product, reporter_name, component, resolution = tuple(bug)
            todo = self.tasklist.new()
            todo.category = self.cat
            todo['description'] = "%s-%s: %s" % (priority, component, short_Desc)
            todo['complete'] = bug_status == "RESOLVED"
            todo['note'] = """ID: %s
Reporter: %s
Severity: %s
Priority: %s
Product: %s
Component: %s
Resolution: %s
Status: %s
URL: %s

%s""" % (bug_id, reporter_name, priority, bug_severity, product, component, resolution,
         bug_status, "%s?id=%s" % (self.url,bug_id), short_Desc)
            self.tasklist.save(todo)
            self.log("Created %s" % todo)

        self.log("Closing database connection")
        self.sqlcurs.close()
        self.sqlcon.close()
        self.sync_completed = 1        

    def sync(self,sd):
        if self.sync_completed:        
            self.log("Synchronised during pre sync",sd=sd)
        else:
            self.log("Failed to pre sync",sd=sd)            
        
