#
#  mutt_alias.py
#
#  Copyright 2002 Nick Piper <nick@nickpiper.co.uk>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU Library General Public License, version 2,
#  as published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Library General Public License for more details.
#
#  You should have received a copy of the GNU Library General Public License
#  along with this program; if not, write the Free Software Foundation,
#  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
#

import jppy
import string

class MuttAliasSync(jppy.conduit):
    def __init__(self,alias_file,category=[],prefix="Category_"):
        self.alias_file = alias_file
        self.category = category
        self.prefix = prefix

    def post_sync(self):
        lists = {}
        ab = jppy.addressBook()
        cat_names = ab.getCategories()
        for cat in cat_names:
            lists[cat] = []
            
        for contact in ab.records(categories=self.category):
            if contact['email']:
                lists[cat_names[contact.category]].append(
                    "%s %s <%s>" % (contact['firstname'],
                                    contact['lastname'],
                                    contact['email']))

        self.log("Exporting to %s" % self.alias_file)
        aliases = open(self.alias_file,"w")
        for alias_name, alias_contents in lists.items():
            if len(alias_contents) > 0:
                aliases.write("alias %s%s %s\n" % (
                    alias_name,self.prefix,string.join(alias_contents,", ")))
        aliases.close()

    def log(self,str,sd=None):
        jppy.log("mutt_alias: %s" % str,sd=sd)
