import jppy
from jppy.gui import GooCalendar
import gtk
import sys
import gobject
import datetime


def on_event_clicked(calendar, event, event_store):
    print "Event %s was clicked" % event.record

def on_day_selected(calendar, day):
    print "Day %s was clicked" % day
    calendar.set_zoom(calendar.ZOOM_WEEK)


class EventStore(gobject.GObject):
    __gsignals__ = {
        'changed': (gobject.SIGNAL_RUN_FIRST,
                    gobject.TYPE_NONE,
                    (gobject.TYPE_PYOBJECT,))
    }

    category_colors = {0: 'grey',
                       1: 'red',
                       2: 'blue',
                       3: 'orange',
                       4: 'green',
                       5: 'purple',
                       6: 'brown',
                       7: 'yellow',
                       8: 'silver',
                       9: 'pink',
                       10: 'turquoise'}    

    def __init__(self):
        """
        Constructor.
        
        start -- datetime
        end -- datetime
        """
        self.__gobject_init__()
        self.events = []
        self.events_cached_range = None

    def get_events(self, start, end):
        """
        Returns a list of all events that intersect with the given start
        and end times.
        """
        period = end-start
        print start, period
        if self.events_cached_range is not None:
            if self.events_cached_range == (start, period):
                print "Cache good for %s events" % len(self.events)
                return self.events

        self.events_cached_range = (start, period)
        self.events = []
        for date, event in jppy.calendar().eventsFromDate(start,
                                                          days=period.days,
                                                          seconds=period.seconds,
                                                          microseconds=period.microseconds):
            try:
                start = datetime.datetime(date.year, date.month, date.day,
                                          event["begin"].hour,
                                          event["begin"].minute,
                                          event["begin"].second)
                all_day = False
            except AttributeError:
                start = datetime.datetime(date.year, date.month, date.day)
                all_day = True
            try:
                end   = datetime.datetime(date.year, date.month, date.day,
                                          event["end"].hour,
                                          event["end"].minute,
                                          event["end"].second)
            except AttributeError:
                end = datetime.datetime(date.year, date.month, date.day)


            bg_color   = self.category_colors[event.category]
            self.events.append(GooCalendar.Event(event, start, end,
                                                 all_day=all_day,
                                                 bg_color=bg_color))
        return self.events


window      = gtk.Window()
event_store = EventStore()
calendar    = GooCalendar.Calendar(event_store)


#calendar.select_from_tuple((2007, 10, 8))
#calendar.select_next_page()
#calendar.select_previous_page()
window.add(calendar)
window.set_size_request(700, 700)
window.show_all()

window.connect('delete-event', gtk.main_quit)
calendar.connect('event-clicked', on_event_clicked, event_store)
calendar.connect('day-selected',  on_day_selected)

gtk.main()
