# Copyright (C) 2007 Samuel Abels <http://debain.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2, as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
import gobject
import datetime
import util

class EventStore(gobject.GObject):
    __gsignals__ = {
        'event-removed': (gobject.SIGNAL_RUN_FIRST,
                          gobject.TYPE_NONE,
                          (gobject.TYPE_PYOBJECT,)),
        'event-added': (gobject.SIGNAL_RUN_FIRST,
                        gobject.TYPE_NONE,
                        (gobject.TYPE_PYOBJECT,))
    }

    def __init__(self):
        """
        Constructor.
        
        start -- datetime
        end -- datetime
        """
        self.__gobject_init__()
        self.next_event_id = 0
        self.events        = {}


    def remove(self, event):
        assert event is not None
        if event.id is None:
            return
        del self.events[event.id]
        self.emit('event-removed', event)


    def add(self, event):
        assert event    is not None
        assert event.id is None
        self.events[self.next_event_id] = event
        event.id = self.next_event_id
        self.next_event_id += 1
        self.emit('event-added', event)


    def get_events(self, start, end):
        """
        Returns a list of all events that intersect with the given start
        and end times.
        """
        events = []
        for event in self.events.values():
            if util.event_intersects(event, start, end):
                events.append(event)
        return events
