// -*- C -*- 
// File: jpilot.i



/* %title "Interface with Jpilot" */

%module _jpilot

%{
#include <gtk/gtk.h>

#include "pytype_events.h"
#include "pytype_appointment.h"
#include "pytype_addresses.h"
#include "pytype_contacts.h"
#include "pytype_memos.h"
#include "pytype_todos.h"

#include "jpilot_helpers.h"

#include <pi-address.h>
#include <pi-calendar.h>
#include <pi-datebook.h>
#include <pi-contact.h>
#include <pi-memo.h>
#include <pi-todo.h>

#include <pi-dlp.h>

#include "../jpilot_src/libplugin.h"
#include "../jpilot_src/utils.h"

  // Hacky stuff to provide symbols jpilot wants
int *glob_date_label;
int pipe_in, pipe_out;
int pipe_to_parent, pipe_from_parent;
pid_t glob_child_pid;
GtkWidget *glob_dialog;
pid_t glob_child_pid;

pid_t jpilot_master_pid;

void output_to_pane(const char *str) {
  printf("output_to_pane: %s\n", str);
}

 int glob_log_file_mask  = 0xFFFF;
 int glob_log_stdout_mask  =  0;
 int glob_log_gui_mask  = 0;



/* %section "Logging Functions" */

/* %subsection "Constants" */


#define JP_LOG_DEBUG  1    /*debugging info for programers, and bug reports */
#define JP_LOG_INFO   2    /*info, and misc messages */
#define JP_LOG_WARN   4    /*worse messages */
#define JP_LOG_FATAL  8    /*even worse messages */
#define JP_LOG_STDOUT 256  /*messages always go to stdout */
#define JP_LOG_FILE   512  /*messages always go to the log file */
#define JP_LOG_GUI    1024 /*messages always go to the gui window */

#define CLEAR_FLAG  1
#define CANCEL_FLAG 2
#define DELETE_FLAG 3
#define MODIFY_FLAG 4
#define NEW_FLAG    5
#define COPY_FLAG   6

#define SPENT_PC_RECORD_BIT 256

#define PALM_REC 100
#define MODIFIED_PALM_REC 101
#define DELETED_PALM_REC 102
#define NEW_PC_REC 103
#define DELETED_PC_REC  SPENT_PC_RECORD_BIT + 104
#define DELETED_DELETED_PALM_REC SPENT_PC_RECORD_BIT + 105

%}

%init %{
  mxDateTime_ImportModuleAndAPI();

  if (PyType_Ready(&AddressType) < 0)
    return;
  Py_INCREF(&AddressType);
  PyModule_AddObject(m, "Address", (PyObject *)&AddressType);

  if (PyType_Ready(&ContactType) < 0)
    return;
  Py_INCREF(&ContactType);
  PyModule_AddObject(m, "Contact", (PyObject *)&ContactType);

  if (PyType_Ready(&MemoType) < 0)
    return;
  Py_INCREF(&MemoType);
  PyModule_AddObject(m, "Memo", (PyObject *)&MemoType);

  if (PyType_Ready(&TodoType) < 0)
    return;
  Py_INCREF(&TodoType);
  PyModule_AddObject(m, "Todo", (PyObject *)&TodoType);

  if (PyType_Ready(&EventType) < 0)
    return;
  Py_INCREF(&EventType);
  PyModule_AddObject(m, "Event", (PyObject *)&EventType);

  if (PyType_Ready(&AppointmentType) < 0)
    return;
  Py_INCREF(&AppointmentType);
  PyModule_AddObject(m, "Appointment", (PyObject *)&AppointmentType);
%}

%pythoncode %{ 
Todo = __jpilot.Todo
Memo = __jpilot.Memo
Contact = __jpilot.Contact
Address = __jpilot.Address
Event = __jpilot.Event
Appointment = __jpilot.Appointment
%} 

/* %subsection "Record Management" */

/* This had %val buf_rec, but: Warning(102): %val directive deprecated
   (ignored). */
/* I just pulled it out, and the (little) test suite still seems
   happy..., so I might just leave it. like that for now. */
int jp_pc_write(char *DB_name, buf_rec *br);

#if defined(SWIGPYTHON)
%typemap(numinputs=0) ToDoAppInfo ai {}
%typemap(out) ToDoAppInfo ai {}
#endif


%{

  /********************** APP INFO *************************/
  
  PyObject *w_jp_get_app_info(char *DB_name) {
    int rec_size;
    unsigned char *buf;
    jp_get_app_info(DB_name,&buf, &rec_size);  
    if (rec_size)     return Py_BuildValue("s#",buf,rec_size);
    else              return Py_BuildValue("");
  }

  PyObject *w_read_AddressAppInfo(char *database) {
    struct AddressAppInfo ai;
    int rec_size;
    unsigned char *buf;
    PyObject *labels;
    int i;

    jp_get_app_info(database, &buf, &rec_size);
    if (unpack_AddressAppInfo(&ai, buf, rec_size)<= 0) {
      PyErr_Format(PyExc_IOError,
		   "Not able to read app info from database %s", 
		   database);
      free(buf);
      return NULL;      
    }
    free(buf);

    labels = PyList_New(19+3);
    for (i = 0; i < 19+3; i++) {
       PyList_SetItem(labels,i,PyString_FromString(ai.labels[i]));
    }

    /* Want to take phonelabels, addresslabels and imlabels from the
       appinfo, once we have a method to get them out of the opaque
       array*/

    return Py_BuildValue("{s:O,s:O,s:i}",
                         "categories",
                         AppInfoCategories_to_PyList(&ai.category),
			 "labels",
			 labels,
			 "_storageversion",
			 ai.type);
  }


  PyObject *w_read_ContactAppInfo(char *database) {
    struct ContactAppInfo ai;
    int rec_size;
    unsigned char *buf;
    pi_buffer_t *pibuf;
    PyObject *labels, *imLabels, *contactLabels, *addressTypeLabels, *addressLabels;
    int i, map;
    contactsType type;

    jp_get_app_info(database, &buf, &rec_size);
    pibuf = pi_buffer_new(rec_size);
    memcpy(pibuf->data, buf, rec_size);
    pibuf->used = rec_size;
    free(buf);
    if (unpack_ContactAppInfo(&ai, pibuf) < 0) {
      PyErr_Format(PyExc_IOError,
		   "Not able to read app info from database %s", 
		   database);
      pi_buffer_free(pibuf);
      return NULL;      
    }
    pi_buffer_free(pibuf);
    
    labels = PyList_New(ai.numCustoms);
    for (i = 0; i < ai.numCustoms; i++) {
       PyList_SetItem(labels,i,PYUNICODE_DECODE(ai.customLabels[i]));
    }

    contactLabels = PyList_New(17);
    for (i = 0; i < 17; i++) {
       PyList_SetItem(contactLabels,i,PYUNICODE_DECODE(ai.labels[i]));
    }

    addressLabels = PyList_New(4);
    PyList_SetItem(addressLabels,0,PYUNICODE_DECODE(ai.labels[24]));
    PyList_SetItem(addressLabels,1,PYUNICODE_DECODE(ai.labels[25]));
    PyList_SetItem(addressLabels,2,PYUNICODE_DECODE(ai.labels[26]));
    PyList_SetItem(addressLabels,3,PYUNICODE_DECODE(ai.labels[27]));

    addressTypeLabels = PyList_New(3);
    for (i = 0; i < 3; i++) {
       PyList_SetItem(addressTypeLabels,i,PYUNICODE_DECODE(ai.addrLabels[i]));
    }

    imLabels = PyList_New(5);
    for (i = 0; i < 5; i++) {
       PyList_SetItem(imLabels,i,PYUNICODE_DECODE(ai.IMLabels[i]));
    }

    type = ai.type;

    free_ContactAppInfo(&ai);

    /* Want to take phonelabels, addresslabels and imlabels from the
       appinfo, once we have a method to get them out of the opaque
       array*/

    return Py_BuildValue("{s:O,s:O,s:i,s:[ssssssss],s:O,s:O,s:O,s:O}",
                         "categories",
                         AppInfoCategories_to_PyList(&ai.category),
			 "customlabels",
			 labels,
			 "_storageversion",
			 type,
			 "phonelabels",
			 "Work",
			 "Home",
			 "Fax",
			 "Other",
			 "Email",
			 "Main",
			 "Pager",
			 "Mobile",
			 "imlabels",
			 imLabels,
			 "contactlabels",
			 contactLabels,
			 "addresstypelabels",
			 addressTypeLabels,
			 "addresslabels",
			 addressLabels);
  }


  PyObject *w_read_MemoAppInfo(char *database) {
    struct MemoAppInfo ai;
    int rec_size;
    unsigned char *buf;
    int num;

    jp_get_app_info(database, &buf, &rec_size);
    if (unpack_MemoAppInfo(&ai, buf, rec_size) <= 0) {
      PyErr_Format(PyExc_IOError,
		   "Not able to read app info from database %s", 
		   database);
      free(buf);
      return NULL;      
    }

    free(buf);

    return Py_BuildValue("{s:O,s:i,s:i}",
			 "categories",
			 AppInfoCategories_to_PyList(&ai.category),
			 "sortByAlpha",
			 ai.sortByAlpha,
			 "_storageversion",
			 ai.type);
  }


  PyObject *w_read_ToDoAppInfo(char *database) {
    struct ToDoAppInfo ai;
    int rec_size;
    unsigned char *buf;

    jp_get_app_info(database, &buf, &rec_size);
    if (unpack_ToDoAppInfo(&ai, buf, rec_size)<= 0) {
      PyErr_Format(PyExc_IOError,
		   "Not able to read app info from database %s", 
		   database);
      free(buf);
      return NULL;      
    }
    free(buf);

    return Py_BuildValue("{s:O,s:i,s:i}",
			 "categories",
			 AppInfoCategories_to_PyList(&ai.category),
			 "sortByPriority",
			 ai.sortByPriority,
			 "_storageversion",
			 ai.type);

  }

  PyObject *w_read_CalendarAppInfo(char *database) {
    struct CalendarAppInfo ai;
    int rec_size;
    unsigned char *buf;

    jp_get_app_info(database, &buf, &rec_size);
    if (unpack_CalendarAppInfo(&ai, buf, rec_size)<= 0) {
      PyErr_Format(PyExc_IOError,
		   "Not able to read app info from database %s", 
		   database);
      free(buf);
      return NULL;      
    }
    free(buf);

    return Py_BuildValue("{s:O,s:i,s:i}",
			 "categories",
			 AppInfoCategories_to_PyList(&ai.category),
			 "startOfWeek",
			 ai.startOfWeek,
			 "_storageversion",
			 ai.type); // TODO must have forgotten ai.type in pi-datebook.h :-/

  }

  PyObject *w_read_DatebookAppInfo(char *database) {
    AppointmentAppInfo_t ai;
    int rec_size;
    unsigned char *buf;

    jp_get_app_info(database, &buf, &rec_size);
    if (unpack_AppointmentAppInfo(&ai, buf, rec_size)<= 0) {
      PyErr_Format(PyExc_IOError,
		   "Not able to read app info from database %s", 
		   database);
      free(buf);
      return NULL;      
    }
    free(buf);

    return Py_BuildValue("{s:O,s:i,s:i}",
			 "categories",
			 AppInfoCategories_to_PyList(&ai.category),
			 "startOfWeek",
			 ai.startOfWeek,
			 "_storageversion",
			 datebook_v1); // TODO must have forgotten ai.type in pi-datebook.h :-/

  }
  
  /********************** RECORDS *************************/
  typedef int (unpackerFunction)(void*, pi_buffer_t*, int);
  typedef PyObject* (wrapFunction)(void*, int, unsigned int, unsigned char, int, void*, PyObject*);

  PyObject *w_jp_read_DB(unpackerFunction unpackerfunc,
			 wrapFunction wrapfunc,
			 void *recordstruct,
			 int recordtype,
			 PyObject *(stringfunc)(),
			 PyObject *regexp, 
			 unsigned int unique_id, 
			 int sort_order, int modified,
			 int deleted, int privates, 
			 int *category_list, char *database,
			 PyObject *filters) {
    PyObject *py_list;
    GList *records;
    GList *temp_list;
    pi_buffer_t *buf;
    int include_flag;
    int i,n;
    PyObject *result;



    py_list = PyList_New(0);
    records = NULL;

    if ((n = read_DB_and_rewind_list(database, &records)) < 0) {
      PyErr_Format(PyExc_IOError, "Unable to read jpilot database %s", database);
      return NULL;
    }
     
    //printf("Read %d records from %s\n", n, database);

    for (temp_list = records; 
	 temp_list; 
	 temp_list = temp_list->next) {
      buf_rec *br = NULL;
      
      if ((temp_list == NULL) || (temp_list->data == NULL)) {
	PyErr_Format(PyExc_RuntimeError, 
		     "Link list failure when reading %s", database);
	pi_buffer_free(buf);
	return NULL;	
      } else {
	//printf("Pointing br at the data\n");
	br = (buf_rec *)temp_list->data;
      }

      //printf("Processing record id %d\n", br->unique_id);
      
      if (((br->rt==DELETED_PALM_REC) || 
	   (br->rt==DELETED_PC_REC)   ||
	   (br->rt==DELETED_DELETED_PALM_REC)) && 
	  (!deleted))
	continue;

      if ((br->rt==MODIFIED_PALM_REC) && (!modified))
	continue;
      
      if (!privates && (br->attrib & dlpRecAttrSecret)) {
	continue;
      }
      
      include_flag = 1;
      if(category_list[0] != -1) {
	include_flag = 0;
	for(n=0;n<16;n++) {
	  if(category_list[n]==-1) { break;}
	  if(category_list[n]==(br->attrib & 0x0F)) {
	    include_flag = 1;
	    break;
	  }
	}
      }

      if(include_flag == 0)
	continue;
      
      if ((unique_id != 0) && (br->unique_id!=unique_id)) 
	continue;

      buf = pi_buffer_new(br->size);
      memcpy(buf->data,br->buf,br->size);
      buf->used = br->size;

      if (unpackerfunc(recordstruct, buf, recordtype) < 0) {
	PyErr_Format(PyExc_IOError, "Unable to unpack record %i from %s", br->unique_id, database);
	jp_free_DB_records(&records);
	Py_DECREF(py_list);	
	pi_buffer_free(buf);
	return NULL;
      }

      pi_buffer_free(buf);      

      //printf("Going to check regexp\n");
      
      if ((regexp != NULL) && (regexp != Py_None)) {
	PyObject *searchname, *searchstring;
	searchname = Py_BuildValue("s","search");
	searchstring = stringfunc(recordstruct);
	if (searchstring == NULL) {
	  /*
	    PyErr_Format(PyExc_RuntimeError, 
	    "Unable to create search string for record %d", 
	    br->unique_id);
	  */
	  Py_DECREF(searchname);
	  jp_free_DB_records(&records);
	  Py_DECREF(py_list);	
	  return NULL;
	}
	//printf("Going to search %s\n", PyString_AsString(searchstring));
	if (PyObject_HasAttr(regexp, searchname)) {
	  if (PyString_Size(searchstring) > 0) {
	    result = PyObject_CallMethodObjArgs(regexp,
						searchname,
						searchstring,
						NULL);
	  } else {
	    /* search string is zero length */
	    Py_INCREF(Py_None);
	    result = Py_None;
	  }
	} else {
	  PyErr_SetString(PyExc_RuntimeError, 
			  "Search object provided has no search method");
	  Py_DECREF(searchname);
	  Py_DECREF(searchstring);
	  jp_free_DB_records(&records);
	  Py_DECREF(py_list);	
	  return NULL;
	}
	Py_DECREF(searchname);
	Py_DECREF(searchstring);
	if (result == NULL) {
	  PyErr_SetString(PyExc_AttributeError, 
			  "Unable to execute search method on regexp object");
	  jp_free_DB_records(&records);
	  Py_DECREF(py_list);	
	  return NULL;
	} else {
	  include_flag = (result != Py_None);
	}	
      }	else {
	include_flag = 1;
      }
	
      //printf("Current include status is %d\n", include_flag);

      if (include_flag == 1) {
	PyObject *item;
	item = wrapfunc(recordstruct,
			br->rt,
			br->unique_id,
			br->attrib,
			br->size,
			br->buf,
			filters);
	if (item == NULL) {
	  jp_free_DB_records(&records);
	  free(category_list);
	  return NULL;
	}
	PyList_Append(py_list, item);
	//printf("appended item uid %d\n", br->unique_id);
      }	
    }
    jp_free_DB_records(&records);
    free(category_list);
    return py_list;
  }

  /*****/
  
  PyObject *BuildPyStringFromToDo(struct ToDo *a) {
    PyObject *list, *result, *sep, *method;
    list = PyList_New(0);
    if (a->description) {
      PyList_Append(list, Py_BuildValue("s",a->description));
    }
    if (a->note) {
      PyList_Append(list, Py_BuildValue("s",a->note));
    }
    sep = PyString_FromString("\n");
    method = Py_BuildValue("s","join");
    result = PyObject_CallMethodObjArgs(sep,method,list,NULL);
    Py_DECREF(sep);
    Py_DECREF(method);
    Py_DECREF(list);
    return result;
  }
  
  PyObject *w_jp_read_ToDoDB(PyObject *regexp, unsigned int unique_id, 
			     int sort_order, int modified,
			     int deleted, int privates, 
			     int *category_list, 
			     char *database, int recordtype,
			     PyObject *filters) {
    struct ToDo a;
    
    return w_jp_read_DB((unpackerFunction *)unpack_ToDo,
			(wrapFunction *)PyPiTodo_Wrap,
			&a,
			recordtype,
			BuildPyStringFromToDo,
			regexp,
			unique_id, 
			sort_order, modified,
			deleted, privates, 
			category_list, database,
			filters);
      
  }

  /*****/

  PyObject *BuildPyStringFromMemo(struct Memo *a) {
    return Py_BuildValue("s",a->text);
  }
  
  PyObject *w_jp_read_MemoDB(PyObject *regexp, unsigned int unique_id, 
			     int sort_order, int modified,
			     int deleted, int privates, 
			     int *category_list, 
			     char *database, int recordtype,
			     PyObject *filters) {
    struct Memo a;
    
    return w_jp_read_DB((unpackerFunction *)unpack_Memo,
			(wrapFunction *)PyPiMemo_Wrap,
			&a,
			recordtype,
			BuildPyStringFromMemo,
			regexp,
			unique_id, 
			sort_order, modified,
			deleted, privates, 
			category_list, database,
			filters);
      
  }

  /*****/

  PyObject *BuildPyStringFromCalendarEvent(struct CalendarEvent *a) {
    PyObject *list, *result, *sep, *method;
    list = PyList_New(0);
    if (a->description) {
      PyList_Append(list, Py_BuildValue("s",a->description));
    }
    if (a->note) {
      PyList_Append(list, Py_BuildValue("s",a->note));
    }
    sep = PyString_FromString("\n");
    method = Py_BuildValue("s","join");
    result = PyObject_CallMethodObjArgs(sep,method,list,NULL);
    Py_DECREF(sep);
    Py_DECREF(method);
    Py_DECREF(list);
    return result;
  }

  PyObject *BuildPyStringFromAppointment(Appointment_t *a) {
    PyObject *list, *result, *sep, *method;
    list = PyList_New(0);
    if (a->description) {
      PyList_Append(list, Py_BuildValue("s",a->description));
    }
    if (a->note) {
      PyList_Append(list, Py_BuildValue("s",a->note));
    }
    sep = PyString_FromString("\n");
    method = Py_BuildValue("s","join");
    result = PyObject_CallMethodObjArgs(sep,method,list,NULL);
    Py_DECREF(sep);
    Py_DECREF(method);
    Py_DECREF(list);
    return result;
  }
  
  
  PyObject *w_jp_read_CalendarDB(PyObject *regexp, unsigned int unique_id, 
				int sort_order, int modified,
				int deleted, int privates, 
				int *category_list, 
				char *database, int recordtype,
				PyObject *filters) {
    struct CalendarEvent a;
    
    return w_jp_read_DB((unpackerFunction *)unpack_CalendarEvent,
			(wrapFunction *)PyPiEvent_Wrap,
			&a,
			recordtype,
			BuildPyStringFromCalendarEvent,
			regexp,
			unique_id, 
			sort_order, modified,
			deleted, privates, 
			category_list, database,
			filters);
      
  }

  PyObject *w_jp_read_DatebookDB(PyObject *regexp, unsigned int unique_id, 
				int sort_order, int modified,
				int deleted, int privates, 
				int *category_list, 
				char *database, int recordtype,
				PyObject *filters) {
    Appointment_t a;
    
    return w_jp_read_DB((unpackerFunction *)unpack_Appointment,
			(wrapFunction *)PyPiAppointment_Wrap,
			&a,
			recordtype,
			BuildPyStringFromAppointment,
			regexp,
			unique_id, 
			sort_order, modified,
			deleted, privates, 
			category_list, database,
			filters);
  }
  
  /*****/

  PyObject *BuildPyStringFromContact(struct Contact *a) {
    PyObject *list, *result, *sep, *method;
    int n = 0;
    list = PyList_New(0);

    for (n=0; n < NUM_CONTACT_ENTRIES; n++) {
      if (a->entry[n]) 
	PyList_Append(list, Py_BuildValue("s",a->entry[n]));
    }	
    sep = PyString_FromString("\n");
    method = Py_BuildValue("s","join");
    result = PyObject_CallMethodObjArgs(sep,method,list,NULL);
    Py_DECREF(sep);
    Py_DECREF(method);
    Py_DECREF(list);
    return result;

  }
  
  PyObject *w_jp_read_ContactDB(PyObject *regexp, unsigned int unique_id, 
				int sort_order, int modified,
				int deleted, int privates, 
				int *category_list, 
				char *database, int recordtype,
				PyObject *filters) {
    struct Contact a;
    
    return w_jp_read_DB((unpackerFunction *)unpack_Contact,
			(wrapFunction *)PyPiContact_Wrap,
			&a,
			recordtype,
			BuildPyStringFromContact,
			regexp,
			unique_id, 
			sort_order, modified,
			deleted, privates, 
			category_list, database,
			filters);
      
  }

  /*****/

  PyObject *BuildPyStringFromAddress(struct Address *a) {
    PyObject *list, *result, *sep, *method;
    int n = 0;
    list = PyList_New(0);

    for (n=0; n < 19; n++) {
      if (a->entry[n]) 
	PyList_Append(list, Py_BuildValue("s",a->entry[n]));
    }	
    sep = PyString_FromString("\n");
    method = Py_BuildValue("s","join");
    result = PyObject_CallMethodObjArgs(sep,method,list,NULL);
    Py_DECREF(sep);
    Py_DECREF(method);
    Py_DECREF(list);
    return result;

  }
  
  PyObject *w_jp_read_AddressDB(PyObject *regexp, unsigned int unique_id, 
				int sort_order, int modified,
				int deleted, int privates, 
				int *category_list, 
				char *database, int recordtype,
				PyObject *filters) {
    struct Address a;
    
    return w_jp_read_DB((unpackerFunction *)unpack_Address,
			(wrapFunction *)PyPiAddress_Wrap,
			&a,
			recordtype,
			BuildPyStringFromAddress,
			regexp,
			unique_id, 
			sort_order, modified,
			deleted, privates, 
			category_list, database,
			filters);
      
  }

%}

#if defined(SWIGPYTHON)
%typemap(out) PyObject *{  $result = $1; }
#endif

#if defined(SWIGPYTHON)
%typemap(in) int* category_list {
  int c;

  if (!PyList_Check($input)) {
    PyErr_SetString(PyExc_TypeError,"category argument must be a list");
    return NULL;
  }

  $1 = malloc(sizeof(int) * (PyList_GET_SIZE($input)+1));

  
  for (c=0;c<PyList_GET_SIZE($input);c++) {
    $1[c] = PyInt_AsLong(PyList_GET_ITEM($input,c));
  }

  $1[PyList_GET_SIZE($input)] = -1;
}
#endif

PyObject *w_jp_read_ContactDB(PyObject *re, unsigned int unique_id, int sort_order, int modified,
			      int deleted, int privates, int* category_list,
			      char *database, int recordtype, PyObject *filters);
PyObject *w_read_ContactAppInfo(char *database);


PyObject *w_jp_read_AddressDB(PyObject *re, unsigned int unique_id, int sort_order, int modified,
			      int deleted, int privates, int* category_list,
			      char *database, int recordtype, PyObject *filters);
PyObject *w_read_AddressAppInfo(char *database);



PyObject *w_jp_read_MemoDB(PyObject *re, unsigned int unique_id, int sort_order, int modified,
			   int deleted, int privates, int* category_list,
			   char *database, int recordtype, PyObject *filters);
PyObject *w_read_MemoAppInfo(char *database);


PyObject *w_jp_read_ToDoDB(PyObject *re, unsigned int unique_id, int sort_order, int modified,
			   int deleted, int privates, int* category_list,
			   char *database, int recordtype, PyObject *filters);
PyObject *w_read_ToDoAppInfo(char *database);


PyObject *w_jp_read_CalendarDB(PyObject *re, unsigned int unique_id, int sort_order, int modified,
			   int deleted, int privates, int* category_list,
			   char *database, int recordtype, PyObject *filters);
PyObject *w_read_CalendarAppInfo(char *database);

PyObject *w_jp_read_DatebookDB(PyObject *re, unsigned int unique_id, int sort_order, int modified,
			   int deleted, int privates, int* category_list,
			   char *database, int recordtype, PyObject *filters);
PyObject *w_read_DatebookAppInfo(char *database);


PyObject *w_jp_get_app_info(char *DB_name);


PyObject *DeleteObjectFromJpilotDatabase(PyObject *record, char *database);
PyObject *SaveObjectToJpilotDatabase(PyObject *record, char *database, int recordtype);

int jp_logf(int level, char *str);

int check_hidden_dir();
int check_copy_DBs_to_home();

%pythoncode %{ 
def jp_logf(str):
  __jpilot.jp_logf(1,str)
  __jpilot.jp_logf(1,"\n")

%}

/* %section "Preferences" */

#define INTTYPE 1
#define CHARTYPE 2

