# trash_after_install.py: conduit for jppy to delete files that are
# installed during a sync
#
# Copyright (C) 2008 Jon Schewe
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  
# 02110-1301, USA.


import jppy
import os.path
import os
import subprocess

class trash_after_install(jppy.conduit):
    '''
    This conduit deletes files that are successfully installed once the
    sync completes. By default the "trash" command
    (http://code.google.com/p/trash-cli/) is used to delete files. This
    allows one to undelete them. You can specify another program in the
    constructor.
    '''

    def __init__(self, command="trash"):
        '''
        Create the conduit. The command argument defaults to trash, but can
        be any program.
        '''
        # keep track of what files were marked for install in pre_sync so that
        # post_sync knows what to delete
        self.files_to_install = []
        self.trash_command = command

    def pre_sync(self):
        to_install = file(os.path.join(os.environ['HOME'],".jpilot","jpilot_to_install"))
        self.files_to_install = []
        for line in to_install:
            line = line.strip()
            print "To install %s" % (line)
            self.files_to_install.append(line)


    def post_sync(self):
        # remove files that were installed
        new_to_install = file(os.path.join(os.environ['HOME'],".jpilot","jpilot_to_install"))
        for line in new_to_install:
            print "File not installed %s" % (line)
            self.files_to_install.remove(line)

        for installed_file in self.files_to_install:
            print "Installed file, removing with %s %s" % (self.trash_command, installed_file)
            try:
                retcode = subprocess.call(["%s \"%s\"" % (self.trash_command, installed_file)], shell=True)
                if retcode < 0:
                    print >>sys.stderr, "%s was terminated by signal: %d while trashing file: %s" % (self.trash_command, -retcode, installed_file)
            except subprocess.OSError, e:
                print >>sys.stderr, "Execution failed on file %s with error %s" % (installed_file, e)
