import unittest
import mx.DateTime
import jppy
import baseclass
import types
import os

class contactTest(baseclass.baseTest):
    def setUp(self):
        baseclass.baseTest.setUp(self)
        self.book = jppy.jpilot.modern.addressBook(self.env)
        self.t = self.book.new()

    def testLabels(self):
        assert type(self.book.getCategories()) == types.ListType
        assert type(self.book.getAddressLabels()) == types.ListType
        assert type(self.book.getIMLabels()) == types.ListType
        assert type(self.book.getPhoneLabels()) == types.ListType

    def testVCard(self):
        self.t["address1"] = "Flat 4\nSomewhere Street\nMore Street"
        self.t["note"]     = "This is a\nmultiline\nnote"
        assert "4=0D=0AS" in self.t.vcard()

    def testPictures(self):
        c = self.book.new()
        c['firstname'] = "Jack"
        self.book.save(c)
        c = self.book.records()[0]
        self.book.save(c)
        image_data = open(os.path.join(os.path.split(__file__)[0],
                                       "image.jpg")).read()
        c['picture'] = image_data
        self.book.save(c)
        c = self.book.records()[0]
        c['lastname'] = "Brown"
        self.book.save(c)
        c = self.book.records()[0]
        assert c['picture'] == image_data

def suite():
    suite = unittest.TestSuite((unittest.makeSuite(contactTest),))
    
    return suite
