/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar.regex;

import com.tonicsystems.jarjar.gnu.regexp.RE;
import com.tonicsystems.jarjar.gnu.regexp.REException;
import com.tonicsystems.jarjar.gnu.regexp.REMatch;
import com.tonicsystems.jarjar.regex.Matcher;
import com.tonicsystems.jarjar.regex.Pattern;
import com.tonicsystems.jarjar.regex.RegexEngine;

public class GnuRegexEngine
implements RegexEngine {
    public Pattern compile(String pattern) {
        try {
            final RE re = new RE(pattern);
            return new Pattern(){

                public String replaceAll(String value, String replace) {
                    return re.substituteAll(value, replace, 0, 128);
                }

                public boolean matches(String value) {
                    return re.isMatch(value);
                }

                public int groupCount() {
                    return re.getNumSubs();
                }

                public Matcher getMatcher(final String value) {
                    final REMatch match = re.getMatch(value, 0);
                    return new Matcher(){

                        public boolean matches() {
                            return re.isMatch(value);
                        }

                        public int start() {
                            return match.getStartIndex();
                        }

                        public int end() {
                            return match.getEndIndex();
                        }

                        public String group(int index) {
                            return match.toString(index);
                        }
                    };
                }

                public String toString() {
                    return re.toString();
                }
            };
        }
        catch (REException e) {
            throw new IllegalArgumentException(e.getMessage()){

                public Throwable getCause() {
                    return e;
                }
            };
        }
    }
}

