/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.util;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.bsf.BSFEngine;
import org.apache.bsf.debug.BSFDebugger;

public class LangCell {
    String m_lang;
    Vector m_engines;
    BSFDebugger m_debugger;

    LangCell(String string) {
        this.m_lang = string;
        this.m_engines = new Vector();
    }

    void terminateNotify() {
        this.disconnectDebugger();
    }

    void disconnectDebugger() {
        this.m_debugger = null;
        Enumeration enumeration = this.m_engines.elements();
        while (enumeration.hasMoreElements()) {
            BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
            bSFEngine.disconnectedDebuggerNotify();
        }
    }

    void setDebugger(BSFDebugger bSFDebugger) {
        if (this.m_debugger != null) {
            this.disconnectDebugger();
        }
        this.m_debugger = bSFDebugger;
        if (this.m_debugger == null) {
            return;
        }
        Enumeration enumeration = this.m_engines.elements();
        while (enumeration.hasMoreElements()) {
            BSFEngine bSFEngine = (BSFEngine)enumeration.nextElement();
            Object object = bSFEngine.getSpecificDebuggingInterface();
            try {
                this.m_debugger.createdEngine(this.m_lang, object);
            }
            catch (RemoteException remoteException) {
                this.disconnectDebugger();
            }
        }
    }

    BSFDebugger getDebugger() {
        return this.m_debugger;
    }

    void addEngine(BSFEngine bSFEngine) {
        this.m_engines.addElement(bSFEngine);
        if (this.m_debugger != null) {
            Object object = bSFEngine.getSpecificDebuggingInterface();
            try {
                this.m_debugger.createdEngine(this.m_lang, object);
            }
            catch (RemoteException remoteException) {
                this.disconnectDebugger();
            }
        }
    }

    void removeEngine(BSFEngine bSFEngine) {
        this.m_engines.removeElement(bSFEngine);
        if (this.m_debugger != null) {
            Object object = bSFEngine.getSpecificDebuggingInterface();
            try {
                this.m_debugger.deletedEngine(object);
            }
            catch (RemoteException remoteException) {
                this.disconnectDebugger();
            }
        }
    }

    Enumeration engines() {
        return this.m_engines.elements();
    }
}

