/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report.html.doc;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.util.IConstants;
import java.io.IOException;
import java.io.Writer;

public final class HTMLWriter {
    private Writer m_out;

    public HTMLWriter(Writer out) {
        if (out == null) {
            throw new IllegalArgumentException("null input: out");
        }
        this.m_out = out;
    }

    public void write(String s) {
        if (this.m_out != null) {
            try {
                this.m_out.write(s);
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
            }
        }
    }

    public void write(char c) {
        if (this.m_out != null) {
            try {
                this.m_out.write(c);
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
            }
        }
    }

    public void eol() {
        if (this.m_out != null) {
            try {
                this.m_out.write(IConstants.EOL);
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
            }
        }
    }

    public void flush() {
        if (this.m_out != null) {
            try {
                this.m_out.flush();
            }
            catch (IOException ioe) {
                throw new EMMARuntimeException("REPORT_IO_FAILURE", ioe);
            }
        }
    }

    public void close() {
        if (this.m_out != null) {
            try {
                this.m_out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_out = null;
        }
    }
}

