/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.dyn.WrongMethodTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CallSite {
    protected MethodHandle target;
    protected final Object caller;
    protected final String name;
    protected final MethodType type;

    protected CallSite(Object object, String string, MethodType methodType) {
        this.caller = object;
        this.name = string;
        this.type = methodType;
    }

    public MethodHandle getTarget() {
        return this.target;
    }

    public void setTarget(MethodHandle methodHandle) {
        this.checkTarget(methodHandle);
        this.target = methodHandle;
    }

    protected void checkTarget(MethodHandle methodHandle) {
        if (!this.canSetTarget(methodHandle)) {
            throw new WrongMethodTypeException(String.valueOf(methodHandle));
        }
    }

    protected boolean canSetTarget(MethodHandle methodHandle) {
        return methodHandle == null || methodHandle.type() == this.type();
    }

    public Class<?> callerClass() {
        return (Class)this.caller;
    }

    public String name() {
        return this.name;
    }

    public MethodType type() {
        return this.type;
    }

    public String toString() {
        return "CallSite#" + this.hashCode() + "[" + this.name + this.type + " => " + this.target + "]";
    }
}

