/*
 * Decompiled with CFR 0.152.
 */
package java.dyn.impl;

import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.dyn.MethodTypeForm;
import java.dyn.Wrappers;
import java.dyn.WrongMethodTypeException;
import java.dyn.impl.Access;
import java.dyn.impl.MH;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMH
extends MethodHandle {
    final MethodHandle target;
    static final int RETYPE_ONLY = 0;
    static final int DROP_INITIAL = 1;
    static final int DROP_FINAL = 2;
    static final int CHECK_CAST = 3;
    static final int EXTEND_SIGN = 4;
    static final int EXTEND_ZERO = 5;
    static final int TEST_BOOLEAN = 6;
    static final int SWAP_ARGUMENT = 7;
    static final int PUSH_ARGUMENT = 8;
    static final int PUSH_PRIMITIVE = 9;
    static final int PUSH_REFERENCE = 10;
    static final int RICOCHET = 11;
    static final int FLYBY = 12;
    static final int CONV_MASK = 255;

    private AMH(MethodHandle methodHandle, MethodType methodType, int n, int n2, Object object) {
        super(Access.TOKEN, methodType);
        this.target = methodHandle;
        MH.init(this, n, n2, object);
        this.checkHandler();
    }

    static MethodHandle buildAdapter(MethodHandle methodHandle, MethodType methodType, int n) {
        MethodType methodType2;
        Class<?> clazz;
        MethodType methodType3 = methodHandle.type();
        if (methodType3 == methodType && n == 0) {
            return methodHandle;
        }
        Class<?> clazz2 = methodType3.returnType();
        int n2 = MH.canPassUnchecked(clazz2, clazz = methodType.returnType());
        if (n2 <= 0) {
            throw new WrongMethodTypeException(methodType + ": cannot return unchecked value from " + methodHandle);
        }
        int n3 = methodType.parameterCount();
        int n4 = 0;
        int n5 = 0;
        Object var11_10 = null;
        int n6 = n3 - methodType3.parameterCount();
        if (n6 != 0) {
            if (n6 < 0) {
                throw new WrongMethodTypeException(methodType + ": not enough arguments for target " + methodHandle);
            }
            List<Class<?>> list = methodType.parameterList();
            if (n == -n6) {
                list = list.subList(n6, list.size());
                n4 = 1;
            } else if (n == n6) {
                list = list.subList(0, list.size() - n6);
                n4 = 2;
            } else {
                throw new WrongMethodTypeException(methodType + ": cannot drop #" + n + " to match " + methodHandle);
            }
            methodType2 = MethodType.make(methodType.returnType(), list);
            n5 = MethodTypeForm.of(methodType2).parameterSlotCount() - MethodTypeForm.of(methodType).parameterSlotCount();
            assert (n5 >= n6);
            assert (n5 <= n6 + MethodTypeForm.of(methodType).longPrimitiveParameterCount());
            methodType = methodType2;
            n3 = methodType.parameterCount();
        }
        assert (n3 == methodType3.parameterCount());
        int n7 = 0;
        int n8 = n3;
        while (--n8 >= 0) {
            clazz2 = methodType.parameterType(n8);
            n2 = MH.canPassUnchecked(clazz2, clazz = methodType3.parameterType(n8));
            if (n2 == 0) {
                throw new WrongMethodTypeException(methodType + ": cannot convert arg #" + n8 + " for target " + methodHandle);
            }
            if (clazz == Long.TYPE || clazz == Double.TYPE) {
                ++n7;
            }
            if (n2 > 0) continue;
            if (!clazz.isPrimitive()) {
                methodType2 = methodType3.newParameterType(n8, clazz2);
                methodHandle = AMH.makeCheckCast(methodHandle, methodType2, n8 + n7, clazz);
                methodType3 = methodType2;
                continue;
            }
            if (clazz == Boolean.TYPE) {
                methodType2 = methodType3.newParameterType(n8, clazz2);
                methodHandle = AMH.makeTestBoolean(methodHandle, methodType2, n8 + n7);
                methodType3 = methodType2;
                continue;
            }
            if (!Wrappers.isSubwordOrInt(clazz2) || !Wrappers.isSubwordOrInt(clazz)) continue;
            methodType2 = methodType3.newParameterType(n8, clazz2);
            methodHandle = AMH.makeExtendInt(methodHandle, methodType2, n8 + n7, Wrappers.isSigned(clazz), Wrappers.bitWidth(clazz));
            methodType3 = methodType2;
        }
        switch (n4) {
            case 1: 
            case 2: {
                methodType = var11_10;
                methodHandle = AMH.makeDropArguments(methodHandle, methodType, n5, n4 == 2);
                break;
            }
            default: {
                assert (n4 == 0);
                break;
            }
        }
        if (methodHandle.type() == methodType) {
            return methodHandle;
        }
        return AMH.makeRetypeOnly(methodHandle, methodType);
    }

    @Override
    public String toString() {
        MethodType methodType = this.type();
        Object object = AMH.nonAdapter(this.target);
        if (object == null) {
            object = "unknown";
        }
        return "Adapted[" + methodType + "," + object + "]";
    }

    private static MethodHandle nonAdapter(MethodHandle methodHandle) {
        while (methodHandle instanceof AMH) {
            methodHandle = ((AMH)methodHandle).target;
        }
        return methodHandle;
    }

    private static int diffTypes(MethodType methodType, MethodType methodType2) {
        Class<?> clazz;
        Class<?> clazz2 = methodType.returnType();
        if (MH.canPassUnchecked(clazz2, clazz = methodType2.returnType()) <= 0) {
            return -1;
        }
        int n = methodType2.parameterCount();
        if (n != methodType.parameterCount()) {
            return -1;
        }
        return AMH.diffTypes(methodType, 0, methodType2, 0, n);
    }

    private static int diffTypes(MethodType methodType, int n, MethodType methodType2, int n2, int n3) {
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            Class<?> clazz;
            Class<?> clazz2 = methodType2.parameterType(n + i);
            if (MH.canPassUnchecked(clazz2, clazz = methodType.parameterType(n2 + i)) > 0) continue;
            if (n4 != 0) {
                return -1 - n4;
            }
            n4 = 1 + i;
        }
        return n4;
    }

    static boolean canRetypeOnly(MethodHandle methodHandle, MethodType methodType) {
        return AMH.diffTypes(methodHandle.type(), methodType) == 0;
    }

    static MethodHandle makeRetypeOnly(MethodHandle methodHandle, MethodType methodType) {
        assert (AMH.canRetypeOnly(methodHandle, methodType));
        return new AMH(methodHandle, methodType, 0, 0, null);
    }

    static boolean canDropArguments(MethodHandle methodHandle, MethodType methodType, int n, boolean bl) {
        MethodType methodType2 = methodHandle.type();
        List<Class<?>> list = methodType2.parameterList();
        if (n > list.size()) {
            return false;
        }
        list = bl ? list.subList(0, list.size() - n) : list.subList(n, list.size());
        MethodType methodType3 = MethodType.make(methodType2.returnType(), list);
        return AMH.diffTypes(methodType3, methodType) == 0;
    }

    static MethodHandle makeDropArguments(MethodHandle methodHandle, MethodType methodType, int n, boolean bl) {
        int n2;
        int n3;
        assert (AMH.canDropArguments(methodHandle, methodType, n, bl));
        MethodTypeForm methodTypeForm = MethodTypeForm.of(methodHandle.type());
        int n4 = methodTypeForm.parameterCount();
        int n5 = methodTypeForm.parameterSlotCount();
        if (n == 0) {
            n3 = 0;
            n2 = 0;
        } else if (n == n4) {
            n3 = 1;
            n2 = n5;
        } else if (bl) {
            n3 = 2;
            int n6 = n4 - n - 1;
            n2 = methodTypeForm.parameterToArgSlot(n6);
            assert (n2 > 0 && n2 < n5);
        } else {
            n3 = 1;
            int n7 = n - 1;
            n2 = n5 - methodTypeForm.parameterToArgSlot(n7);
            assert (n2 > 0 && n2 < n5);
        }
        return new AMH(methodHandle, methodType, n2, n3, null);
    }

    static boolean canCheckCast(MethodHandle methodHandle, MethodType methodType, int n, Class<?> clazz) {
        MethodType methodType2 = methodHandle.type();
        int n2 = MH.canPassUnchecked(clazz, methodType2.parameterType(n));
        if (n2 <= 0) {
            return false;
        }
        n2 = MH.canPassUnchecked(methodType.parameterType(n), clazz);
        if (n2 >= 0) {
            return n2 != 0;
        }
        int n3 = AMH.diffTypes(methodHandle.type(), methodType);
        return n3 == 0 || n3 == n + 1;
    }

    static MethodHandle makeCheckCast(MethodHandle methodHandle, MethodType methodType, int n, Class<?> clazz) {
        assert (AMH.canCheckCast(methodHandle, methodType, n, clazz));
        int n2 = MethodTypeForm.of(methodType).parameterToArgSlot(n);
        return new AMH(methodHandle, methodType, n2, 3, clazz);
    }

    static boolean canExtendInt(MethodHandle methodHandle, MethodType methodType, int n, boolean bl, int n2) {
        if (n >= methodType.parameterCount()) {
            return false;
        }
        if (n2 >= 32 || n2 <= 0) {
            throw new IllegalArgumentException("bitWidth=" + n2);
        }
        MethodType methodType2 = methodHandle.type();
        int n3 = AMH.diffTypes(methodType2, methodType);
        if (n3 != 0 && n3 != n + 1) {
            return false;
        }
        Class<?> clazz = methodType2.parameterType(n);
        Class<?> clazz2 = methodType.parameterType(n);
        if (!Wrappers.isSubwordOrInt(clazz) || !Wrappers.isSubwordOrInt(clazz2)) {
            return false;
        }
        return bl == Wrappers.isSigned(clazz2) && n2 <= Wrappers.bitWidth(clazz2);
    }

    static MethodHandle makeExtendInt(MethodHandle methodHandle, MethodType methodType, int n, boolean bl, int n2) {
        assert (AMH.canExtendInt(methodHandle, methodType, n, bl, n2));
        assert (((n2 <<= 8) & 0xFFFF00FF) == 0);
        int n3 = (bl ? 4 : 5) | n2;
        int n4 = MethodTypeForm.of(methodType).parameterToArgSlot(n);
        return new AMH(methodHandle, methodType, n4, n3, null);
    }

    private static boolean canTestBoolean(MethodHandle methodHandle, MethodType methodType, int n) {
        if (n >= methodType.parameterCount()) {
            return false;
        }
        MethodType methodType2 = methodHandle.type();
        if (AMH.diffTypes(methodType2, methodType) != n + 1) {
            return false;
        }
        if (methodType.parameterType(n) != Boolean.TYPE) {
            return false;
        }
        return Wrappers.isSubwordOrInt(methodType2.parameterType(n));
    }

    private static MethodHandle makeTestBoolean(MethodHandle methodHandle, MethodType methodType, int n) {
        assert (AMH.canTestBoolean(methodHandle, methodType, n));
        int n2 = MethodTypeForm.of(methodType).parameterToArgSlot(n);
        return new AMH(methodHandle, methodType, n2, 6, null);
    }
}

