/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bsf.engines.javascript;

import java.rmi.RemoteException;
import org.apache.bsf.debug.jsdi.JsCode;
import org.apache.bsf.debug.jsdi.JsContext;
import org.apache.bsf.debug.jsdi.JsEngine;
import org.apache.bsf.debug.jsdi.JsObject;
import org.apache.bsf.debug.jsdi.JsdiException;
import org.apache.bsf.debug.util.Skeleton;
import org.apache.bsf.engines.javascript.RhinoContextProxy;
import org.apache.bsf.engines.javascript.RhinoEngineDebugger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;

public class JsContextStub
extends Skeleton
implements JsContext {
    RhinoContextProxy m_rcp;
    RhinoEngineDebugger m_rhinoDbg;
    DebugFrame m_frame;
    int m_frameno;
    boolean m_atBreakpoint;
    boolean m_invalid;

    public JsContextStub(RhinoContextProxy rhinoContextProxy, DebugFrame debugFrame, int n) throws RemoteException {
        super(106);
        this.m_rhinoDbg = rhinoContextProxy.getRhinoEngineDebugger();
        this.m_rcp = rhinoContextProxy;
        this.m_frame = debugFrame;
        this.m_frameno = n;
        this.m_invalid = false;
        this.m_atBreakpoint = true;
    }

    void atBreakpoint(boolean bl) {
        this.m_atBreakpoint = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsObject bind(String string) throws RemoteException {
        JsObject jsObject;
        block5: {
            try {
                Context.enter();
                Scriptable scriptable = this.m_frame.getVariableObject();
                while (true) {
                    if (scriptable == null) {
                        throw new JsdiException("Name not in scope.");
                    }
                    Scriptable scriptable2 = scriptable;
                    do {
                        if (!scriptable2.has(string, scriptable)) continue;
                        jsObject = this.m_rhinoDbg.marshallScriptable(scriptable);
                        Object var7_5 = null;
                        break block5;
                    } while ((scriptable2 = scriptable2.getPrototype()) != null);
                    scriptable = scriptable.getParentScope();
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                Context.exit();
                throw throwable;
            }
        }
        Context.exit();
        return jsObject;
    }

    public JsCode getCode() {
        JsCode jsCode;
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get the code.");
        }
        try {
            Context.enter();
            jsCode = null;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return jsCode;
    }

    public int getDepth() {
        return this.m_frameno;
    }

    public JsEngine getEngine() {
        RhinoEngineDebugger rhinoEngineDebugger = this.m_rcp.getRhinoEngineDebugger();
        return (JsEngine)rhinoEngineDebugger.getDebugInterface();
    }

    public int getLineNumber() {
        int n;
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            n = this.m_frame.getLineNumber();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return n;
    }

    public JsObject getScope() throws RemoteException {
        JsObject jsObject;
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            JsObject jsObject2;
            Context.enter();
            Scriptable scriptable = this.m_frame.getVariableObject();
            jsObject = jsObject2 = this.m_rhinoDbg.marshallScriptable(scriptable);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return jsObject;
    }

    public String getSourceName() {
        String string;
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            string = this.m_frame.getSourceName();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return string;
    }

    public JsObject getThis() throws RemoteException {
        JsObject jsObject;
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            JsObject jsObject2 = null;
            Scriptable scriptable = null;
            NativeCall nativeCall = null;
            Scriptable scriptable2 = this.m_frame.getVariableObject();
            if (scriptable2 instanceof NativeCall) {
                nativeCall = (NativeCall)scriptable2;
                scriptable = nativeCall.getThisObj();
                jsObject2 = this.m_rhinoDbg.marshallScriptable(scriptable2);
            }
            jsObject = jsObject2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return jsObject;
    }

    void invalidate() {
        this.m_invalid = true;
    }

    public boolean isEvalContext() {
        boolean bl;
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            bl = false;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return bl;
    }

    public boolean isFunctionContext() {
        boolean bl;
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            bl = false;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return bl;
    }

    public boolean isScriptContext() {
        boolean bl;
        if (this.m_invalid) {
            throw new JsdiException("This context no longer exists.");
        }
        if (!this.m_atBreakpoint) {
            throw new JsdiException("Resumed context, can't get line number.");
        }
        try {
            Context.enter();
            bl = true;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Context.exit();
            throw throwable;
        }
        Context.exit();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object lookupName(String string) {
        Object object;
        block5: {
            try {
                Context.enter();
                Scriptable scriptable = this.m_frame.getVariableObject();
                while (true) {
                    if (scriptable == null) {
                        throw new JsdiException("Name is not in scope.");
                    }
                    Scriptable scriptable2 = scriptable;
                    do {
                        Object object2;
                        if ((object2 = scriptable2.get(string, scriptable)) == Scriptable.NOT_FOUND) continue;
                        object = object2;
                        Object var8_6 = null;
                        break block5;
                    } while ((scriptable2 = scriptable2.getPrototype()) != null);
                    scriptable = scriptable.getParentScope();
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                Context.exit();
                throw throwable;
            }
        }
        Context.exit();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object lookupName(Scriptable scriptable, String string) {
        Scriptable scriptable2;
        block5: {
            Object object;
            block6: {
                try {
                    Context.enter();
                    Scriptable scriptable3 = scriptable;
                    while (true) {
                        if (scriptable3 == null) {
                            scriptable2 = null;
                            break block5;
                        }
                        scriptable2 = scriptable3;
                        do {
                            Object object2;
                            if ((object2 = scriptable2.get(string, scriptable3)) == Scriptable.NOT_FOUND) continue;
                            object = object2;
                            Object var9_7 = null;
                            break block6;
                        } while ((scriptable2 = scriptable2.getPrototype()) != null);
                        scriptable3 = scriptable3.getParentScope();
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    Context.exit();
                    throw throwable;
                }
            }
            Context.exit();
            return object;
        }
        Object var9_8 = null;
        Context.exit();
        return scriptable2;
    }
}

