/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.specific;

import org.jcodings.CodeRange;
import org.jcodings.EucEncoding;
import org.jcodings.IntHolder;
import org.jcodings.ascii.AsciiTables;
import org.jcodings.exception.EncodingException;
import org.jcodings.exception.InternalException;
import org.jcodings.util.BytesHash;

public final class EUCJPEncoding
extends EucEncoding {
    private static final int[] CR_Hiragana = new int[]{1, 42145, 42227};
    private static final int[] CR_Katakana = new int[]{3, 42401, 42486, 43686, 43695, 43697, 43741};
    private static final int[][] PropertyList = new int[][]{CR_Hiragana, CR_Katakana};
    private static final BytesHash<Integer> CTypeNameHash = new BytesHash();
    static final int[] EUCJPEncLen;
    private static final int[][] EUCJPTrans;
    public static final EUCJPEncoding INSTANCE;

    protected EUCJPEncoding() {
        super(1, 3, EUCJPEncLen, EUCJPTrans, AsciiTables.AsciiCtypeTable);
    }

    public String toString() {
        return "EUC-JP";
    }

    public int length(byte[] bytes, int p, int end) {
        return this.length(bytes[p]);
    }

    public int mbcToCode(byte[] bytes, int p, int end) {
        return this.mbnMbcToCode(bytes, p, end);
    }

    public int codeToMbcLength(int code) {
        if (EUCJPEncoding.isAscii(code)) {
            return 1;
        }
        if ((code & 0xFF0000) != 0) {
            return 3;
        }
        if ((code & 0xFF00) != 0) {
            return 2;
        }
        throw new EncodingException("invalid code point value");
    }

    public int codeToMbc(int code, byte[] bytes, int p) {
        int p_ = p;
        if ((code & 0xFF0000) != 0) {
            bytes[p_++] = (byte)(code >> 16 & 0xFF);
        }
        if ((code & 0xFF00) != 0) {
            bytes[p_++] = (byte)(code >> 8 & 0xFF);
        }
        bytes[p_++] = (byte)(code & 0xFF);
        if (this.length(bytes, p, p_) != p_ - p) {
            throw new EncodingException("invalid code point value");
        }
        return p_ - p;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end, byte[] lower) {
        int p = pp.value++;
        int lowerP = 0;
        if (EUCJPEncoding.isMbcAscii(bytes[p])) {
            lower[lowerP] = AsciiTables.ToLowerCaseTable[bytes[p] & 0xFF];
            return 1;
        }
        int len = this.length(bytes, p, end);
        for (int i = 0; i < len; ++i) {
            lower[lowerP++] = bytes[p++];
        }
        pp.value += len;
        return len;
    }

    protected boolean isLead(int c) {
        return (c - 161 & 0xFF) > 93;
    }

    public boolean isReverseMatchAllowed(byte[] bytes, int p, int end) {
        int c = bytes[p] & 0xFF;
        return c <= 126 || c == 142 || c == 143;
    }

    public int propertyNameToCType(byte[] bytes, int p, int end) {
        Integer ctype = CTypeNameHash.get(bytes, p, end);
        if (ctype == null) {
            return super.propertyNameToCType(bytes, p, end);
        }
        return ctype;
    }

    public boolean isCodeCType(int code, int ctype) {
        if (ctype <= 14) {
            if (code < 128) {
                return this.isCodeCTypeInternal(code, ctype);
            }
            if (EUCJPEncoding.isWordGraphPrint(ctype)) {
                return this.codeToMbcLength(code) > 1;
            }
        } else {
            if ((ctype -= 15) >= PropertyList.length) {
                throw new InternalException("undefined type (bug)");
            }
            return CodeRange.isInCodeRange(PropertyList[ctype], code);
        }
        return false;
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        if (ctype <= 14) {
            return null;
        }
        sbOut.value = 128;
        if ((ctype -= 15) >= PropertyList.length) {
            throw new InternalException("undefined type (bug)");
        }
        return PropertyList[ctype];
    }

    static {
        CTypeNameHash.put("Hiragana".getBytes(), 15);
        CTypeNameHash.put("Katakana".getBytes(), 16);
        EUCJPEncLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1};
        EUCJPTrans = null;
        INSTANCE = new EUCJPEncoding();
    }
}

