/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.mop.beans;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dynalang.mop.BaseMetaobjectProtocol;
import org.dynalang.mop.CallProtocol;
import org.dynalang.mop.beans.DynamicMethod;
import org.dynalang.mop.beans.Invocation;
import org.dynalang.mop.beans.OverloadedDynamicMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OverloadedVarArgMethod<T extends Member> {
    private static final Class<Object> OBJECT_CLASS = Object.class;
    private Class[][] marshalTypes;
    private final Map<ClassString, Object> selectorCache = new ConcurrentHashMap<ClassString, Object>();
    private final List<T> members = new LinkedList<T>();
    private final Map<T, ArgumentPacker> argPackers = new HashMap<T, ArgumentPacker>();

    OverloadedVarArgMethod() {
    }

    void addMember(T member) {
        Class[] oneShorterTypes;
        int i;
        this.members.add(member);
        Class[] argTypes = OverloadedVarArgMethod.getParameterTypes(member);
        int l = argTypes.length;
        this.argPackers.put(member, new ArgumentPacker(argTypes));
        OverloadedVarArgMethod.componentizeLastType(argTypes);
        if (this.marshalTypes == null) {
            this.marshalTypes = new Class[l + 1][];
            this.marshalTypes[l] = argTypes;
            this.updateFromSurroundingVarArg(l);
        } else if (this.marshalTypes.length <= l) {
            Class[][] newMarshalTypes = new Class[l + 1][];
            System.arraycopy(this.marshalTypes, 0, newMarshalTypes, 0, this.marshalTypes.length);
            this.marshalTypes = newMarshalTypes;
            this.marshalTypes[l] = argTypes;
            this.updateFromSurroundingVarArg(l);
        } else {
            Class[] oldTypes = this.marshalTypes[l];
            if (oldTypes == null) {
                this.marshalTypes[l] = argTypes;
            } else {
                for (i = 0; i < oldTypes.length; ++i) {
                    oldTypes[l] = OverloadedVarArgMethod.getMostSpecificCommonType(oldTypes[l], argTypes[l]);
                }
            }
            this.updateFromSurroundingVarArg(l);
        }
        Class[] newTypes = this.marshalTypes[l];
        for (i = l + 1; i < this.marshalTypes.length; ++i) {
            Class[] existingTypes = this.marshalTypes[i];
            if (existingTypes == null) continue;
            OverloadedVarArgMethod.varArgUpdate(existingTypes, newTypes);
        }
        if (l > 0 && (oneShorterTypes = this.marshalTypes[l - 1]) != null) {
            OverloadedVarArgMethod.varArgUpdate(oneShorterTypes, newTypes);
        }
    }

    private void updateFromSurroundingVarArg(int l) {
        Class[] oneLongerTypes;
        Class[] newTypes = this.marshalTypes[l];
        int i = l;
        while (i-- > 0) {
            Class[] previousTypes = this.marshalTypes[i];
            if (previousTypes == null) continue;
            OverloadedVarArgMethod.varArgUpdate(newTypes, previousTypes);
            break;
        }
        if (l + 1 < this.marshalTypes.length && (oneLongerTypes = this.marshalTypes[l + 1]) != null) {
            OverloadedVarArgMethod.varArgUpdate(newTypes, oneLongerTypes);
        }
    }

    private static void varArgUpdate(Class[] modifiedTypes, Class[] modifyingTypes) {
        int dl = modifiedTypes.length;
        int gl = modifyingTypes.length;
        int min = Math.min(gl, dl);
        for (int i = 0; i < min; ++i) {
            modifiedTypes[i] = OverloadedVarArgMethod.getMostSpecificCommonType(modifiedTypes[i], modifyingTypes[i]);
        }
        if (dl > gl) {
            Class varArgType = modifyingTypes[gl - 1];
            for (int i = gl; i < dl; ++i) {
                modifiedTypes[i] = OverloadedVarArgMethod.getMostSpecificCommonType(modifiedTypes[i], varArgType);
            }
        }
    }

    private static void componentizeLastType(Class[] types) {
        int l1 = types.length - 1;
        assert (l1 >= 0);
        assert (types[l1].isArray());
        types[l1] = types[l1].getComponentType();
    }

    Object createInvocation(Object target, Object[] args, CallProtocol callProtocol) {
        ClassString<T> argTypes;
        Object objMember;
        if (args == null) {
            args = DynamicMethod.NULL_ARGS;
        }
        Object[] newArgs = args;
        boolean argsCloned = false;
        block0: for (int i = Math.min(args.length + 1, this.marshalTypes.length - 1); i >= 0; --i) {
            Class[] types = this.marshalTypes[i];
            if (types == null) {
                if (i != 0) continue;
                return OverloadedDynamicMethod.NO_SUCH_METHOD;
            }
            for (int j = 0; j < args.length; ++j) {
                Object dst = callProtocol.representAs(args[j], j < i ? types[j] : types[i - 1]);
                if (dst == BaseMetaobjectProtocol.Results.noAuthority || dst == BaseMetaobjectProtocol.Results.noRepresentation) continue block0;
                if (dst == newArgs[j]) continue;
                if (!argsCloned) {
                    newArgs = (Object[])args.clone();
                }
                newArgs[j] = dst;
            }
        }
        if ((objMember = this.selectorCache.get(argTypes = new ClassString<T>(newArgs))) == null) {
            objMember = argTypes.getMostSpecific(this.members);
            this.selectorCache.put(argTypes, objMember);
        }
        if (objMember instanceof Member) {
            Member member = (Member)objMember;
            newArgs = this.argPackers.get(member).packArgs(args, argsCloned, callProtocol);
            if (newArgs == null) {
                return OverloadedDynamicMethod.NO_SUCH_METHOD;
            }
            return new Invocation<Member>(target, member, newArgs);
        }
        return objMember;
    }

    private static Class getMostSpecificCommonType(Class c1, Class c2) {
        if (c1 == c2) {
            return c1;
        }
        if (c2.isPrimitive()) {
            if (c2 == Byte.TYPE) {
                c2 = Byte.class;
            } else if (c2 == Short.TYPE) {
                c2 = Short.class;
            } else if (c2 == Character.TYPE) {
                c2 = Character.class;
            } else if (c2 == Integer.TYPE) {
                c2 = Integer.class;
            } else if (c2 == Float.TYPE) {
                c2 = Float.class;
            } else if (c2 == Long.TYPE) {
                c2 = Long.class;
            } else if (c2 == Double.TYPE) {
                c2 = Double.class;
            }
        }
        Set<Class> a1 = OverloadedVarArgMethod.getAssignables(c1, c2);
        Set<Class> a2 = OverloadedVarArgMethod.getAssignables(c2, c1);
        a1.retainAll(a2);
        if (a1.isEmpty()) {
            return Object.class;
        }
        ArrayList<Class> max = new ArrayList<Class>();
        block0: for (Class clazz : a1) {
            Iterator maxiter = max.iterator();
            while (maxiter.hasNext()) {
                Class maxClazz = (Class)maxiter.next();
                if (OverloadedVarArgMethod.isMoreSpecific(maxClazz, clazz)) continue block0;
                if (!OverloadedVarArgMethod.isMoreSpecific(clazz, maxClazz)) continue;
                maxiter.remove();
            }
            max.add(clazz);
        }
        if (max.size() > 1) {
            return OBJECT_CLASS;
        }
        return (Class)max.get(0);
    }

    private static boolean isMoreSpecific(Class<?> specific, Class<?> generic) {
        if (generic.isAssignableFrom(specific)) {
            return true;
        }
        if (generic.isPrimitive()) {
            if (generic == Short.TYPE && specific == Byte.TYPE) {
                return true;
            }
            if (generic == Integer.TYPE && (specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Long.TYPE && (specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Float.TYPE && (specific == Long.TYPE || specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Double.TYPE && (specific == Float.TYPE || specific == Long.TYPE || specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
        }
        return false;
    }

    private static Set<Class> getAssignables(Class c1, Class c2) {
        HashSet<Class> s = new HashSet<Class>();
        OverloadedVarArgMethod.collectAssignables(c1, c2, s);
        return s;
    }

    private static void collectAssignables(Class<?> c1, Class<?> c2, Set<Class> s) {
        Class<?> sc;
        if (c1.isAssignableFrom(c2)) {
            s.add(c1);
        }
        if ((sc = c1.getSuperclass()) != null) {
            OverloadedVarArgMethod.collectAssignables(sc, c2, s);
        }
        Class<?>[] itf = c1.getInterfaces();
        for (int i = 0; i < itf.length; ++i) {
            OverloadedVarArgMethod.collectAssignables(itf[i], c2, s);
        }
    }

    private static Class[] getParameterTypes(Member member) {
        if (member instanceof Method) {
            return ((Method)member).getParameterTypes();
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).getParameterTypes();
        }
        throw new AssertionError();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClassString<T extends Member> {
        private final Class[] classes;
        private static final int MORE_SPECIFIC = 0;
        private static final int LESS_SPECIFIC = 1;
        private static final int INDETERMINATE = 2;

        ClassString(Object[] objects) {
            int l = objects.length;
            this.classes = new Class[l];
            for (int i = 0; i < l; ++i) {
                Object obj = objects[i];
                this.classes[i] = obj == null ? OBJECT_CLASS : obj.getClass();
            }
        }

        Class[] getClasses() {
            return this.classes;
        }

        public int hashCode() {
            int hash = 0;
            for (int i = 0; i < this.classes.length; ++i) {
                hash ^= this.classes[i].hashCode();
            }
            return hash;
        }

        public boolean equals(Object o) {
            if (o instanceof ClassString) {
                ClassString cs = (ClassString)o;
                if (cs.classes.length != this.classes.length) {
                    return false;
                }
                for (int i = 0; i < this.classes.length; ++i) {
                    if (cs.classes[i] == this.classes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        Object getMostSpecific(List<T> methods) {
            LinkedList<T> applicables = this.getApplicables(methods);
            if (applicables.isEmpty()) {
                return OverloadedDynamicMethod.NO_SUCH_METHOD;
            }
            if (applicables.size() == 1) {
                return applicables.getFirst();
            }
            LinkedList<Member> maximals = new LinkedList<Member>();
            for (Member applicable : applicables) {
                Class[] appArgs = OverloadedVarArgMethod.getParameterTypes(applicable);
                boolean lessSpecific = false;
                Iterator maximal = maximals.iterator();
                while (maximal.hasNext()) {
                    Member max = (Member)maximal.next();
                    Class[] maxArgs = OverloadedVarArgMethod.getParameterTypes(max);
                    switch (ClassString.moreSpecific(appArgs, maxArgs)) {
                        case 0: {
                            maximal.remove();
                            break;
                        }
                        case 1: {
                            lessSpecific = true;
                        }
                    }
                }
                if (lessSpecific) continue;
                maximals.addLast(applicable);
            }
            if (maximals.size() > 1) {
                return OverloadedDynamicMethod.AMBIGUOUS_METHOD;
            }
            return maximals.getFirst();
        }

        private static int moreSpecific(Class[] c1, Class[] c2) {
            boolean c1MoreSpecific = false;
            boolean c2MoreSpecific = false;
            int cl1 = c1.length;
            int cl2 = c2.length;
            int m = Math.max(cl1, cl2);
            for (int i = 0; i < m; ++i) {
                Class class2;
                Class class1 = ClassString.getClass(c1, cl1, i);
                if (class1 == (class2 = ClassString.getClass(c2, cl2, i))) continue;
                c1MoreSpecific = c1MoreSpecific || OverloadedVarArgMethod.isMoreSpecific(class1, class2);
                c2MoreSpecific = c2MoreSpecific || OverloadedVarArgMethod.isMoreSpecific(class2, class1);
            }
            if (c1MoreSpecific) {
                if (c2MoreSpecific) {
                    return 2;
                }
                return 0;
            }
            if (c2MoreSpecific) {
                return 1;
            }
            return 2;
        }

        private static Class getClass(Class[] classes, int l, int i) {
            return i < l - 1 ? classes[i] : classes[l - 1].getComponentType();
        }

        LinkedList<T> getApplicables(List<T> methods) {
            LinkedList<Member> list = new LinkedList<Member>();
            for (Member member : methods) {
                if (!this.isApplicable(member)) continue;
                list.add(member);
            }
            return list;
        }

        private boolean isApplicable(T member) {
            int cl = this.classes.length;
            Class[] formalTypes = OverloadedVarArgMethod.getParameterTypes(member);
            int fl1 = formalTypes.length - 1;
            if (cl < fl1) {
                return false;
            }
            for (int i = 0; i < fl1; ++i) {
                if (ClassString.isMethodInvocationConvertible(formalTypes[i], this.classes[i])) continue;
                return false;
            }
            Class<?> varArgType = formalTypes[fl1].getComponentType();
            for (int i = fl1; i < cl; ++i) {
                if (ClassString.isMethodInvocationConvertible(varArgType, this.classes[i])) continue;
                return false;
            }
            return true;
        }

        private static boolean isMethodInvocationConvertible(Class<?> formal, Class<?> actual) {
            if (formal.isAssignableFrom(actual)) {
                return true;
            }
            if (formal.isPrimitive()) {
                if (formal == Boolean.TYPE) {
                    return actual == Boolean.class;
                }
                if (formal == Character.TYPE) {
                    return actual == Character.class;
                }
                if (formal == Byte.TYPE && actual == Byte.class) {
                    return true;
                }
                if (formal == Short.TYPE && (actual == Short.class || actual == Byte.class)) {
                    return true;
                }
                if (formal == Integer.TYPE && (actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                    return true;
                }
                if (formal == Long.TYPE && (actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                    return true;
                }
                if (formal == Float.TYPE && (actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                    return true;
                }
                if (formal == Double.TYPE && (actual == Double.class || actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class ArgumentPacker {
        private final int argCount;
        private final Class varArgType;

        ArgumentPacker(Class[] argTypes) {
            this.argCount = argTypes.length;
            this.varArgType = argTypes[this.argCount - 1].getComponentType();
        }

        Object[] packArgs(Object[] args, boolean cloned, CallProtocol callProtocol) {
            int actualArgCount = args.length;
            int fixArgCount = this.argCount - 1;
            if (args.length != this.argCount) {
                Object[] newargs = new Object[this.argCount];
                System.arraycopy(args, 0, newargs, 0, fixArgCount);
                Object array = Array.newInstance(this.varArgType, actualArgCount - fixArgCount);
                for (int i = fixArgCount; i < actualArgCount; ++i) {
                    Object val = callProtocol.representAs(args[i], this.varArgType);
                    if (val == BaseMetaobjectProtocol.Results.noRepresentation || val == BaseMetaobjectProtocol.Results.noAuthority) {
                        return null;
                    }
                    Array.set(array, i - fixArgCount, val);
                }
                newargs[fixArgCount] = array;
                return newargs;
            }
            Object val = callProtocol.representAs(args[fixArgCount], this.varArgType);
            if (val == BaseMetaobjectProtocol.Results.noRepresentation || val == BaseMetaobjectProtocol.Results.noAuthority) {
                return null;
            }
            Object array = Array.newInstance(this.varArgType, 1);
            Array.set(array, 0, val);
            if (!cloned) {
                args = (Object[])args.clone();
            }
            args[fixArgCount] = array;
            return args;
        }
    }
}

