/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.harmony.runtime.java.lang;

public final class Character_ {
    public static final char MIN_HIGH_SURROGATE = '\ud800';
    public static final char MAX_HIGH_SURROGATE = '\udbff';
    public static final char MIN_LOW_SURROGATE = '\udc00';
    public static final char MAX_LOW_SURROGATE = '\udfff';
    public static final char MIN_SURROGATE = '\ud800';
    public static final char MAX_SURROGATE = '\udfff';
    public static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    public static final int MIN_CODE_POINT = 0;
    public static final int MAX_CODE_POINT = 0x10FFFF;
    public static final int SIZE = 16;
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final /* synthetic */ Class class$net$sourceforge$retroweaver$harmony$runtime$java$lang$Character_;

    public static boolean isValidCodePoint(int codePoint) {
        return 0 <= codePoint && 0x10FFFF >= codePoint;
    }

    public static boolean isSupplementaryCodePoint(int codePoint) {
        return 65536 <= codePoint && 0x10FFFF >= codePoint;
    }

    public static boolean isHighSurrogate(char ch) {
        return '\ud800' <= ch && '\udbff' >= ch;
    }

    public static boolean isLowSurrogate(char ch) {
        return '\udc00' <= ch && '\udfff' >= ch;
    }

    public static boolean isSurrogatePair(char high, char low) {
        return Character_.isHighSurrogate(high) && Character_.isLowSurrogate(low);
    }

    public static int charCount(int codePoint) {
        return codePoint >= 65536 ? 2 : 1;
    }

    public static int toCodePoint(char high, char low) {
        int h = (high & 0x3FF) << 10;
        int l = low & 0x3FF;
        return (h | l) + 65536;
    }

    public static int codePointAt(CharSequence seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (index < 0 || index >= len) {
            throw new IndexOutOfBoundsException();
        }
        char high = seq.charAt(index++);
        if (index >= len) {
            return high;
        }
        char low = seq.charAt(index);
        if (Character_.isSurrogatePair(high, low)) {
            return Character_.toCodePoint(high, low);
        }
        return high;
    }

    public static int codePointAt(char[] seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length;
        if (index < 0 || index >= len) {
            throw new IndexOutOfBoundsException();
        }
        char high = seq[index++];
        if (index >= len) {
            return high;
        }
        char low = seq[index];
        if (Character_.isSurrogatePair(high, low)) {
            return Character_.toCodePoint(high, low);
        }
        return high;
    }

    public static int codePointAt(char[] seq, int index, int limit) {
        if (index < 0 || index >= limit || limit < 0 || limit > seq.length) {
            throw new IndexOutOfBoundsException();
        }
        char high = seq[index++];
        if (index >= limit) {
            return high;
        }
        char low = seq[index];
        if (Character_.isSurrogatePair(high, low)) {
            return Character_.toCodePoint(high, low);
        }
        return high;
    }

    public static int codePointBefore(CharSequence seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (index < 1 || index > len) {
            throw new IndexOutOfBoundsException();
        }
        char low = seq.charAt(--index);
        if (--index < 0) {
            return low;
        }
        char high = seq.charAt(index);
        if (Character_.isSurrogatePair(high, low)) {
            return Character_.toCodePoint(high, low);
        }
        return low;
    }

    public static int codePointBefore(char[] seq, int index) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length;
        if (index < 1 || index > len) {
            throw new IndexOutOfBoundsException();
        }
        char low = seq[--index];
        if (--index < 0) {
            return low;
        }
        char high = seq[index];
        if (Character_.isSurrogatePair(high, low)) {
            return Character_.toCodePoint(high, low);
        }
        return low;
    }

    public static int codePointBefore(char[] seq, int index, int start) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length;
        if (index <= start || index > len || start < 0 || start >= len) {
            throw new IndexOutOfBoundsException();
        }
        char low = seq[--index];
        if (--index < start) {
            return low;
        }
        char high = seq[index];
        if (Character_.isSurrogatePair(high, low)) {
            return Character_.toCodePoint(high, low);
        }
        return low;
    }

    public static int toChars(int codePoint, char[] dst, int dstIndex) {
        if (!Character_.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException();
        }
        if (dst == null) {
            throw new NullPointerException();
        }
        if (dstIndex < 0 || dstIndex >= dst.length) {
            throw new IndexOutOfBoundsException();
        }
        if (Character_.isSupplementaryCodePoint(codePoint)) {
            if (dstIndex == dst.length - 1) {
                throw new IndexOutOfBoundsException();
            }
            int cpPrime = codePoint - 65536;
            int high = 0xD800 | cpPrime >> 10 & 0x3FF;
            int low = 0xDC00 | cpPrime & 0x3FF;
            dst[dstIndex] = (char)high;
            dst[dstIndex + 1] = (char)low;
            return 2;
        }
        dst[dstIndex] = (char)codePoint;
        return 1;
    }

    public static char[] toChars(int codePoint) {
        if (!Character_.isValidCodePoint(codePoint)) {
            throw new IllegalArgumentException();
        }
        if (Character_.isSupplementaryCodePoint(codePoint)) {
            int cpPrime = codePoint - 65536;
            int high = 0xD800 | cpPrime >> 10 & 0x3FF;
            int low = 0xDC00 | cpPrime & 0x3FF;
            return new char[]{(char)high, (char)low};
        }
        return new char[]{(char)codePoint};
    }

    public static int codePointCount(CharSequence seq, int beginIndex, int endIndex) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (beginIndex < 0 || endIndex > len || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = seq.charAt(i);
            if (Character_.isHighSurrogate(c) && ++i < endIndex && !Character_.isLowSurrogate(c = seq.charAt(i))) {
                ++result;
            }
            ++result;
        }
        return result;
    }

    public static int codePointCount(char[] seq, int offset, int count) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length;
        int endIndex = offset + count;
        if (offset < 0 || count < 0 || endIndex > len) {
            throw new IndexOutOfBoundsException();
        }
        int result = 0;
        for (int i = offset; i < endIndex; ++i) {
            char c = seq[i];
            if (Character_.isHighSurrogate(c) && ++i < endIndex && !Character_.isLowSurrogate(c = seq[i])) {
                ++result;
            }
            ++result;
        }
        return result;
    }

    public static int offsetByCodePoints(CharSequence seq, int index, int codePointOffset) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int len = seq.length();
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException();
        }
        if (codePointOffset == 0) {
            return index;
        }
        if (codePointOffset > 0) {
            int codePoints = codePointOffset;
            int i = index;
            while (codePoints > 0) {
                int next;
                --codePoints;
                if (i >= len) {
                    throw new IndexOutOfBoundsException();
                }
                if (Character_.isHighSurrogate(seq.charAt(i)) && (next = i + 1) < len && Character_.isLowSurrogate(seq.charAt(next))) {
                    ++i;
                }
                ++i;
            }
            return i;
        }
        if (!$assertionsDisabled && codePointOffset >= 0) {
            throw new AssertionError();
        }
        int codePoints = -codePointOffset;
        int i = index;
        while (codePoints > 0) {
            int prev;
            --codePoints;
            if (--i < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (!Character_.isLowSurrogate(seq.charAt(i)) || (prev = i - 1) < 0 || !Character_.isHighSurrogate(seq.charAt(prev))) continue;
            --i;
        }
        return i;
    }

    public static int offsetByCodePoints(char[] seq, int start, int count, int index, int codePointOffset) {
        if (seq == null) {
            throw new NullPointerException();
        }
        int end = start + count;
        if (start < 0 || count < 0 || end > seq.length || index < start || index > end) {
            throw new IndexOutOfBoundsException();
        }
        if (codePointOffset == 0) {
            return index;
        }
        if (codePointOffset > 0) {
            int codePoints = codePointOffset;
            int i = index;
            while (codePoints > 0) {
                int next;
                --codePoints;
                if (i >= end) {
                    throw new IndexOutOfBoundsException();
                }
                if (Character_.isHighSurrogate(seq[i]) && (next = i + 1) < end && Character_.isLowSurrogate(seq[next])) {
                    ++i;
                }
                ++i;
            }
            return i;
        }
        if (!$assertionsDisabled && codePointOffset >= 0) {
            throw new AssertionError();
        }
        int codePoints = -codePointOffset;
        int i = index;
        while (codePoints > 0) {
            int prev;
            --codePoints;
            if (--i < start) {
                throw new IndexOutOfBoundsException();
            }
            if (!Character_.isLowSurrogate(seq[i]) || (prev = i - 1) < start || !Character_.isHighSurrogate(seq[prev])) continue;
            --i;
        }
        return i;
    }

    public static char reverseBytes(char c) {
        return (char)(c << 8 | c >> 8);
    }

    static {
        Class<?> clazz = class$net$sourceforge$retroweaver$harmony$runtime$java$lang$Character_;
        if (clazz == null) {
            clazz = class$net$sourceforge$retroweaver$harmony$runtime$java$lang$Character_ = new Character_[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

