/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;

public abstract class Strings {
    public static final String WHITE_SPACE = " \t\r\n";
    private static final boolean USE_GET_CHARS = true;

    public static String toListForm(String[] strings, char delimiter) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return "";
        }
        StringBuffer s = new StringBuffer();
        int iLimit = strings.length;
        for (int i = 0; i < iLimit; ++i) {
            if (i != 0) {
                s.append(delimiter);
            }
            s.append(strings[i]);
        }
        return s.toString();
    }

    public static String[] removeDuplicates(String[] strings, boolean removeNull) {
        if (strings == null) {
            return strings;
        }
        int length = strings.length;
        if (length == 0) {
            return strings;
        }
        HashSet<String> _strings = new HashSet<String>(length);
        ArrayList<String> _result = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            String s = strings[i];
            if (removeNull && s == null || !_strings.add(s)) continue;
            _result.add(s);
        }
        int resultLength = _result.size();
        if (resultLength == length) {
            return strings;
        }
        String[] result = new String[resultLength];
        _result.toArray(result);
        return result;
    }

    public static String[] merge(String[] strings, String delimiters, boolean removeNull) {
        if (strings == null) {
            return strings;
        }
        int length = strings.length;
        if (length == 0) {
            return strings;
        }
        if (delimiters == null || delimiters.length() == 0) {
            throw new IllegalArgumentException("null/empty input: delimiters");
        }
        HashSet<String> _strings = new HashSet<String>(length);
        ArrayList<String> _result = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            String s = strings[i];
            if (removeNull && s == null) continue;
            StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
            while (tokenizer.hasMoreTokens()) {
                String ss = tokenizer.nextToken();
                if (!_strings.add(ss)) continue;
                _result.add(ss);
            }
        }
        String[] result = new String[_result.size()];
        _result.toArray(result);
        return result;
    }

    public static String[] mergeAT(String[] strings, String delimiters, boolean processAtFiles) throws IOException {
        if (!processAtFiles) {
            return Strings.merge(strings, delimiters, true);
        }
        if (strings == null) {
            return strings;
        }
        int length = strings.length;
        if (length == 0) {
            return strings;
        }
        if (delimiters == null || delimiters.length() == 0) {
            throw new IllegalArgumentException("null/empty input: delimiters");
        }
        HashSet<String> _strings = new HashSet<String>(length);
        ArrayList<String> _result = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            String s = strings[i];
            if (s == null) continue;
            StringTokenizer tokenizer = new StringTokenizer(s, delimiters);
            while (tokenizer.hasMoreTokens()) {
                String ss = tokenizer.nextToken();
                if (ss.startsWith("@")) {
                    String[] fileList = Files.readFileList(new File(ss.substring(1)));
                    for (int j = 0; j < fileList.length; ++j) {
                        String sss = fileList[j];
                        if (!_strings.add(sss)) continue;
                        _result.add(sss);
                    }
                    continue;
                }
                if (!_strings.add(ss)) continue;
                _result.add(ss);
            }
        }
        String[] result = new String[_result.size()];
        _result.toArray(result);
        return result;
    }

    public static void HTMLEscape(String s, StringBuffer append) {
        if (s == null) {
            throw new IllegalArgumentException("null input: s");
        }
        if (append == null) {
            throw new IllegalArgumentException("null input: append");
        }
        char[] chars = s.toCharArray();
        int iLimit = s.length();
        block6: for (int i = 0; i < iLimit; ++i) {
            char c = chars[i];
            switch (c) {
                case '<': {
                    append.append("&lt;");
                    continue block6;
                }
                case '>': {
                    append.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    append.append("&#34;");
                    continue block6;
                }
                case '&': {
                    append.append("&amp;");
                    continue block6;
                }
                default: {
                    append.append(c);
                }
            }
        }
    }

    public static void HTMLEscapeNB(String s, StringBuffer append) {
        if (s == null) {
            throw new IllegalArgumentException("null input: s");
        }
        if (append == null) {
            throw new IllegalArgumentException("null input: append");
        }
        char[] chars = s.toCharArray();
        int iLimit = s.length();
        block8: for (int i = 0; i < iLimit; ++i) {
            char c = chars[i];
            switch (c) {
                case ' ': {
                    append.append('\u00a0');
                    continue block8;
                }
                case '\t': {
                    append.append("\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0\u00a0");
                    continue block8;
                }
                case '<': {
                    append.append("&lt;");
                    continue block8;
                }
                case '>': {
                    append.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    append.append("&#34;");
                    continue block8;
                }
                case '&': {
                    append.append("&amp;");
                    continue block8;
                }
                default: {
                    append.append(c);
                }
            }
        }
    }

    public static String HTMLEscape(String s) {
        StringBuffer buf = new StringBuffer();
        Strings.HTMLEscape(s, buf);
        return buf.toString();
    }

    public static String HTMLEscapeSP(String s) {
        StringBuffer buf = new StringBuffer();
        Strings.HTMLEscapeNB(s, buf);
        return buf.toString();
    }

    private Strings() {
    }
}

